/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>

#include "singit_macros.h"
#include "singit_config.h"

#include "gtkglmaterialdialog.h"
#include "displayer_opengl.h"

#include "dlg_opengl_config.h"

static GtkWidget *opengl_config_win = NULL;
static GtkWidget
	*config_vbox,
		*config_bass_sensitivity_frame,
			*config_bass_sensitivity_table,
				*config_high_bass_label, *config_high_bass_hscale,
				*config_low_bass_label, *config_low_bass_hscale,

				*config_direct_apply_check_button,
				*config_display_particles_check_button,

		*opengl_material_button,
//			*config_opengl_material_dialog,
		*bottom_button_hbox,
			*bottom_button_ok,
			*bottom_button_cancel,
			*bottom_button_apply;

static GtkObject
	*config_high_bass_hscale_adj = NULL,
	*config_low_bass_hscale_adj = NULL;

OpenGLConfig *opengl_config = NULL;

void opengl_config_new(void)
{
	if (opengl_config) { return; }

#	ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_new]\n"));
#	endif

	opengl_config = g_malloc(sizeof(OpenGLConfig));

	opengl_config->isLoaded = FALSE;
	opengl_config->attachments = 1;
}

void opengl_config_free()
{
	if (!opengl_config) { return; }

#	ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_free]\n"));
#	endif

	g_free(opengl_config);
	opengl_config = NULL;
}

gboolean opengl_config_load()
{
	ConfigFile *cfg;

#	ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_load] : "));
#	endif

	if (!opengl_config_attach()) {
#		ifdef CODEDEBUG
		DEBUG(("failed\n"));
#		endif
		return FALSE;
	}

	cfg = singit_config_open();
	if (!cfg) { cfg = xmms_cfg_new(); }

	if (!(xmms_cfg_read_int(cfg, "SingIt", "sensitivityBassLow", &opengl_config->sensitivity_bass_low)))
		{ opengl_config->sensitivity_bass_low = 20; }
	if (!(xmms_cfg_read_int(cfg, "SingIt", "sensitivityBassHigh", &opengl_config->sensitivity_bass_high)))
		{ opengl_config->sensitivity_bass_high = 20; }

	if (!xmms_cfg_read_boolean(cfg, "SingIt", "directApply", &opengl_config->direct_apply))
		{ opengl_config->direct_apply = FALSE; }
	if (!xmms_cfg_read_boolean(cfg, "SingIt", "displayParticles", &opengl_config->display_particles))
		{ opengl_config->display_particles = TRUE; }

	singit_config_close(cfg, FALSE);

	opengl_config->isLoaded = TRUE;

	opengl_config_detach(TRUE);

#	ifdef CODEDEBUG
	DEBUG(("Ok\n"));
#	endif

	return TRUE;
}

gboolean opengl_config_save()
{
	ConfigFile *cfg;

	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_save_editor] :\n"));
	#endif

	cfg = singit_config_open();
	if (!cfg) { return FALSE; }

	xmms_cfg_write_int(cfg, "SingIt", "sensitivityBassLow", opengl_config->sensitivity_bass_low);
	xmms_cfg_write_int(cfg, "SingIt", "sensitivityBassHigh", opengl_config->sensitivity_bass_high);
	xmms_cfg_write_boolean(cfg, "SingIt", "directApply", opengl_config->direct_apply);
	xmms_cfg_write_boolean(cfg, "SingIt", "displayParticles", opengl_config->display_particles);

	return singit_config_close(cfg, TRUE);
}

gboolean opengl_config_attach()
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_attach] : "));
	#endif

	if (opengl_config != NULL) {
		opengl_config->attachments++;
		#ifdef CODEDEBUG
		DEBUG(("Attached\n"));
		#endif
		return TRUE;
	}
	#ifdef CODEDEBUG
	DEBUG(("Failed\n"));
	#endif
	return FALSE;
}

gboolean opengl_config_detach(gboolean free)
{
	if (!opengl_config) { return TRUE; }

	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_detach] : "));
	#endif

	opengl_config->attachments--;
	if (opengl_config->attachments == 0) {
		if (free) {
			#ifdef CODEDEBUG
			DEBUG(("Freed\n"));
			#endif
			opengl_config_free();
		}
		return TRUE;
	}
	#ifdef CODEDEBUG
	DEBUG(("Detached\n"));
	#endif
	return FALSE;
}


void config_dis_plugins_use_cb(GtkWidget * w, gpointer data)
{

}

void config_low_bass_hscale_value_changed_event(GtkAdjustment *adj, gpointer user_data)
{

}

void config_high_bass_hscale_value_changed_event(GtkAdjustment *adj, gpointer user_data)
{

}


static void opengl_config_cleanup(gboolean save)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_cleanup]\n"));
	#endif

	if (save) { opengl_config_save(); }

	opengl_config_detach(TRUE);
}

void opengl_config_apply_clicked(GtkButton *button, gpointer user_data)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_apply_clicked] : "));
	#endif

	if (!opengl_config_win || !opengl_config_attach(opengl_config)) {
		#ifdef CODEDEBUG
		DEBUG(("failed\n"));
		#endif
		return;
	}

	opengl_config->sensitivity_bass_high =
		(gint) GTK_ADJUSTMENT(config_high_bass_hscale_adj)->value;
	opengl_config->sensitivity_bass_low =
		(gint) GTK_ADJUSTMENT(config_low_bass_hscale_adj)->value;
	opengl_config->direct_apply =
		GTK_TOGGLE_BUTTON(config_direct_apply_check_button)->active;
	opengl_config->display_particles =
		GTK_TOGGLE_BUTTON(config_display_particles_check_button)->active;

	#ifdef CODEDEBUG
	DEBUG(("Ok\n"));
	#endif

	opengl_config_detach(TRUE);
}

void opengl_material_changed(GtkGLMaterialDialog *dlg, gpointer user_data)
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_material_changed]\n"));
	#endif

	gtk_widget_destroy(GTK_WIDGET(dlg));
}

void opengl_material_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *config_opengl_material_dialog;

	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_material_clicked]\n"));
	#endif

	config_opengl_material_dialog = gtk_gl_material_dialog_new("Test Material");
	gtk_signal_connect(GTK_OBJECT(config_opengl_material_dialog), "delete_event",
		GTK_SIGNAL_FUNC(gtk_widget_destroy), config_opengl_material_dialog);
	gtk_signal_connect(GTK_OBJECT(config_opengl_material_dialog), "material_changed",
		GTK_SIGNAL_FUNC(opengl_material_changed), NULL);
	gtk_widget_show(config_opengl_material_dialog);
}

void opengl_config_ok_clicked(GtkButton *button, gpointer user_data)
{
	/* apply and save config */
	opengl_config_apply_clicked(button, user_data);
	opengl_config_cleanup(TRUE);

	/* close and destroy window */
	gtk_widget_destroy(opengl_config_win);
}

void opengl_config_cancel_clicked(GtkButton *button, gpointer user_data)
{
	opengl_config_cleanup(FALSE);

	/* close and destroy window */
	gtk_widget_destroy(opengl_config_win);
}

gint dlg_opengl_config_delete_event( GtkWidget *widget, GdkEvent  *event, gpointer data )
{
	opengl_config_cleanup(FALSE);

	/* close and destroy window */
	gtk_widget_destroy(opengl_config_win);

	return (FALSE);
}

void opengl_config_show()
{
	#ifdef CODEDEBUG
	DEBUG(("dlg_opengl_config.c [opengl_config_show]\n"));
	#endif

	if (opengl_config_win) {
		gdk_window_raise(opengl_config_win->window);
		return;
	}

	if (!opengl_config_attach()) {
		opengl_config_new();
		opengl_config_load();
	}
	if (!opengl_config) { return; }

	opengl_config_win = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect(GTK_OBJECT(opengl_config_win), "delete_event",
		GTK_SIGNAL_FUNC(dlg_opengl_config_delete_event), NULL);

	/* update opengl_config_win when window is destroyed */
	gtk_signal_connect(GTK_OBJECT(opengl_config_win), "destroy",
		       GTK_SIGNAL_FUNC(gtk_widget_destroyed), &opengl_config_win);

	gtk_window_set_title(GTK_WINDOW(opengl_config_win), "OpenGL Config");
	gtk_window_set_policy(GTK_WINDOW(opengl_config_win), FALSE, FALSE, FALSE);
	gtk_container_border_width(GTK_CONTAINER(opengl_config_win), 5);

	config_vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(opengl_config_win), config_vbox);
	gtk_widget_show(config_vbox);


	config_bass_sensitivity_frame = gtk_frame_new(_("Bass Sensitivity"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_bass_sensitivity_frame, TRUE, TRUE, 0);
	gtk_widget_show(config_bass_sensitivity_frame);

	config_bass_sensitivity_table = gtk_table_new (2, 2, FALSE);
	gtk_table_set_row_spacings (GTK_TABLE (config_bass_sensitivity_table), 3);
	gtk_table_set_col_spacings (GTK_TABLE (config_bass_sensitivity_table), 3);
	gtk_container_set_border_width(GTK_CONTAINER(config_bass_sensitivity_table), 2);
	gtk_container_add(GTK_CONTAINER(config_bass_sensitivity_frame), config_bass_sensitivity_table);
	gtk_widget_show(config_bass_sensitivity_table);

	config_high_bass_label = gtk_label_new(_("High"));
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_high_bass_label, 0, 1, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_high_bass_label);

	config_high_bass_hscale_adj = gtk_adjustment_new
		(opengl_config->sensitivity_bass_high, 0, 101, 1, 1, 1);
	gtk_signal_connect (GTK_OBJECT (config_high_bass_hscale_adj), "value_changed",
		GTK_SIGNAL_FUNC (config_high_bass_hscale_value_changed_event), NULL);
	config_high_bass_hscale = gtk_hscale_new( GTK_ADJUSTMENT(config_high_bass_hscale_adj) );
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_high_bass_hscale, 1, 2, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_high_bass_hscale);

	config_low_bass_label = gtk_label_new(_("Low"));
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_low_bass_label, 0, 1, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_low_bass_label);

	config_low_bass_hscale_adj = gtk_adjustment_new
		(opengl_config->sensitivity_bass_low, 0, 101, 1, 1, 1);
	gtk_signal_connect (GTK_OBJECT (config_low_bass_hscale_adj), "value_changed",
		GTK_SIGNAL_FUNC (config_low_bass_hscale_value_changed_event), NULL);
	config_low_bass_hscale = gtk_hscale_new( GTK_ADJUSTMENT(config_high_bass_hscale_adj) );
	gtk_table_attach (GTK_TABLE (config_bass_sensitivity_table), config_low_bass_hscale, 1, 2, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(config_low_bass_hscale);

	config_direct_apply_check_button = gtk_check_button_new_with_label(_("Apply directly"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_direct_apply_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_direct_apply_check_button),
		opengl_config->direct_apply);
	gtk_widget_show(config_direct_apply_check_button);

	config_display_particles_check_button = gtk_check_button_new_with_label(_("Show particles"));
	gtk_box_pack_start(GTK_BOX(config_vbox), config_display_particles_check_button, FALSE, FALSE, 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config_display_particles_check_button),
		opengl_config->display_particles);
	gtk_widget_show(config_display_particles_check_button);

	opengl_material_button = gtk_button_new_with_label(_("Material..."));
	gtk_signal_connect_object(GTK_OBJECT(opengl_material_button), "clicked", GTK_SIGNAL_FUNC(opengl_material_clicked), (GtkObject*) TRUE);
	gtk_box_pack_start(GTK_BOX(config_vbox), opengl_material_button, TRUE, TRUE, 0);
	gtk_widget_show(opengl_material_button);

/*
	Bottom button row ([Ok] [Cancel] [Apply])
*/
	bottom_button_hbox = gtk_hbutton_box_new();
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bottom_button_hbox), 5);
	gtk_box_pack_start(GTK_BOX(config_vbox), bottom_button_hbox, FALSE, FALSE, 0);
	gtk_widget_show(bottom_button_hbox);

	bottom_button_ok = gtk_button_new_with_label(_("Ok"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_ok), "clicked", GTK_SIGNAL_FUNC(opengl_config_ok_clicked), (GtkObject*) TRUE);
	GTK_WIDGET_SET_FLAGS(bottom_button_ok, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_ok, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_ok);

	bottom_button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_cancel), "clicked", GTK_SIGNAL_FUNC(opengl_config_cancel_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_cancel, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_cancel, TRUE, TRUE, 0);
	gtk_widget_grab_default(bottom_button_cancel);
	gtk_widget_show(bottom_button_cancel);

	bottom_button_apply = gtk_button_new_with_label(_("Apply"));
	gtk_signal_connect_object(GTK_OBJECT(bottom_button_apply), "clicked", GTK_SIGNAL_FUNC(opengl_config_apply_clicked), NULL);
	GTK_WIDGET_SET_FLAGS(bottom_button_apply, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(bottom_button_hbox), bottom_button_apply, TRUE, TRUE, 0);
	gtk_widget_show(bottom_button_apply);

	gtk_widget_show(opengl_config_win);
}

void opengl_config_hide()
{
	if (opengl_config_win) { opengl_config_cancel_clicked(NULL, NULL); }
}
