/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <string.h>

#include "singit_macros.h"
#include "singit_macros_private.h"
#include "singit_song.h"
#include "singit_song_private.h"
#include "singit_sha.h"
#include "singit_tools.h"

gboolean l_song_load_id3v2xx_lyrics(LSong *song, gchar *filename)
{
	size_t nDataSize, len;
	ID3Frame *id3_frame;
	ID3Field *id3_field;
	luint frm_size;
	ID3Tag *new_tag = NULL;

	luint num_chars;
	gchar *dyn_text = NULL, *dyn_pos = NULL, *lyrics = NULL, *lyrics_pos = NULL;
	uint32 timstamp_format = 0, content_type = 0;
	guint token_counter = 1, line_counter = 0;
	LToken *token = NULL;
	GList *item = NULL;

	#ifdef CODEDEBUG
	DEBUG(("singit_song_id3v2xx.c [l_song_load_id3v2xx_lyrics]\n"), 9);
	#endif

	if (!l_song_attach(song)) { return FALSE; }

	if (song->id3tag) { ID3Tag_Clear(song->id3tag); }
	else { song->id3tag = ID3Tag_New(); }

	if (filename) { frm_size = ID3Tag_Link(new_tag, filename); }
	else { frm_size = ID3Tag_Link(new_tag, song->song_filename); }

	if (frm_size <= 0) {
		ID3Tag_Delete(song->id3tag);
		song->id3tag = NULL;
		l_song_detach(song, TRUE);
		return FALSE;
	}

	if (!ID3Tag_HasTagType(song->id3tag,
		ID3TT_ID3V2 | ID3TT_LYRICS3 | ID3TT_LYRICS3V2 | ID3TT_MUSICMATCH)) { return FALSE; }

	if ((id3_frame = ID3Tag_FindFrameWithID(song->id3tag, ID3FID_SYNCEDLYRICS)) != NULL) {
		if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_TIMESTAMPFORMAT)) != NULL) {
			timstamp_format = ID3Field_GetINT (id3_field); // (2 == nTimestamp) ? "ms" : "frames"
		}
		if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_CONTENTTYPE)) != NULL) {
			content_type = ID3Field_GetINT (id3_field);
/*			switch (content_type) {
			case ID3CT_OTHER:    cout << "Other"; break;
			case ID3CT_LYRICS:   cout << "Lyrics"; break;
			case ID3CT_TEXTTRANSCRIPTION:     cout << "Text transcription"; break;
			case ID3CT_MOVEMENT: cout << "Movement/part name"; break;
			case ID3CT_EVENTS:   cout << "Events"; break;
			case ID3CT_CHORD:    cout << "Chord"; break;
			case ID3CT_TRIVIA:   cout << "Trivia/'pop up' information"; break;
			}*/
		}
		if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_DATA)) != NULL) {
			content_type = ID3Field_GetINT (id3_field);
			nDataSize = ID3Field_Size(id3_field);
			dyn_text = g_new(gchar, ID3Field_Size(id3_field));
			lyrics = g_new(gchar, ID3Field_Size(id3_field));
			ID3Field_GetBINARY (id3_field, dyn_text, nDataSize);

			dyn_pos = dyn_text;
			lyrics_pos = lyrics;
			while (dyn_pos < dyn_text + nDataSize) {
				len = strlen(dyn_pos);
				if (len > 0) {
					memcpy(dyn_pos, lyrics_pos, len);
					lyrics_pos += len;
				}
				dyn_pos += len + 1;
				if (dyn_pos < dyn_text + nDataSize) {
					token = g_malloc(sizeof(LToken));
					token->pos = (lyrics_pos - lyrics);
					token->line = token_counter;
					token_counter++;
					memcpy(dyn_pos, &token->time, sizeof(uint32));
					song->first_token = g_list_insert_sorted(song->first_token,
						token, compare_token_by_time);
					dyn_pos += 4;
				}
			}
			item = song->first_token = g_list_first(song->first_token);
			song->last_token = g_list_last(song->first_token);
			song->lyrics = g_strsplit (lyrics, "\n", 1000);
			token_counter = strlen(song->lyrics[0]);
			while (item) {
				while ((guint)tPos(item) > token_counter) {
					line_counter++;
					token_counter += strlen(song->lyrics[line_counter]);
				}
				tLine(item) = line_counter;
				item = g_list_next(item);
			}
		}
	}
	else {
		if ((id3_frame = ID3Tag_FindFrameWithID(song->id3tag, ID3FID_UNSYNCEDLYRICS)) != NULL) {
			if ((id3_field = ID3Frame_GetField(id3_frame, ID3FN_TEXT)) != NULL) {
				dyn_text = g_new(gchar, ID3Field_Size(id3_field));
				num_chars = ID3Field_GetASCII(id3_field, dyn_text, ID3Field_Size(id3_field), 1);
			}
			l_song_read_text_stream(song, dyn_text);
			g_free(dyn_text);
		}
	}

	l_song_detach(song, TRUE);
	return FALSE;
}
