/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdlib.h>
#include <stdio.h>

#include <xmms/xmmsctrl.h>
#include <xmms/util.h>

#include <SDL/SDL_types.h>
#include <SDL/SDL_syswm.h>
#include <SDL/SDL_ttf.h>

#include "singit/control.h"
#include "singit/displayer_plugin.h"

#include "displayer_test_sdl.h"
#include "displayer_test_sdl_status.h"
#include "test_sdl_lyrics.h"
#include "sdl_helpers.h"
#include "test_sdl_handlers.h"

#include <stdlib.h>
#include <stdio.h>

extern DisplayerPlugin test_sdl_dp;

static gboolean CreateScreen(gint nWidth, gint nHeight, gboolean bFullscreen)
{
	static gint save_full[2] = { -1 };
	gint nFlags, w, h;

	if (bFullscreen == TRUE) {
		sdl_helper_blanking(BLANK_DISABLE);
		nFlags = SDL_SWSURFACE | SDL_FULLSCREEN;
		save_full[0] = displayer_test_sdl_status.screen->w;
		save_full[1] = displayer_test_sdl_status.screen->h;
		w = 640;
		h = 480;
		SDL_WM_GrabInput(SDL_GRAB_ON);
	}
	else {
		sdl_helper_blanking(BLANK_ENABLE);
		nFlags = SDL_SWSURFACE | SDL_RESIZABLE;
		if ((save_full[0] != -1) && (save_full[1] != -1)) {
			w = save_full[0];
			h = save_full[1];
			save_full[0] = -1;
		}
		else {
			w = nWidth;
			h = nHeight;
		}
		SDL_WM_GrabInput(SDL_GRAB_OFF);
	}

	displayer_test_sdl_status.screen =
		SDL_SetVideoMode(w, h, bFullscreen ? 16 : 0, nFlags);
	displayer_test_sdl_status.is_fullscreen = bFullscreen;

	return (displayer_test_sdl_status.screen != NULL);
}

gboolean tsnh_init(void)
{
	gchar *title;

	#ifdef CODEDEBUG
	DEBUG(("test_sdl_handlers.cpp [tsnh_init]\n"));
	#endif

	// Initialise the SDL library
	if (SDL_WasInit(SDL_INIT_VIDEO) > 0) {
		g_print("SDL Video was initialized before : no two SDL windows allowed : exit\n");
		displayer_test_sdl_status.sdl_inuse = TRUE;
		return FALSE;
	}
	else {
		if (SDL_Init(SDL_INIT_VIDEO) != 0) {
			g_print("Unable to init SDL Video: %s\n", SDL_GetError());
			return FALSE;
		}
	}
	displayer_test_sdl_status.song = NULL;

	if (CreateScreen(480, 300, FALSE) == FALSE) {
		g_print("Graphic mode is not available: %s\n", SDL_GetError());
		gtk_idle_add (displayer_test_sdl_disable_func, NULL);
		return FALSE;
	}

	title = g_strconcat(SINGIT_VERSION_STRING, " - ", _("Test SDL displayer (new)"), NULL);
	SDL_WM_SetCaption(title, PACKAGE_NAME);
	g_free(title);

	TTF_Init();
	displayer_test_sdl_status.font = TTF_OpenFont(SINGIT_DATA_DIR "/vixar.ttf", 32);

	return TRUE;
}

void tsnh_finish(void)
{
	#ifdef CODEDEBUG
	DEBUG(("test_sdl_handlers.cpp [tsnh_finish]\n"));
	#endif

	if (displayer_test_sdl_status.font) {
		TTF_CloseFont(displayer_test_sdl_status.font);
		displayer_test_sdl_status.font = NULL;
	}

	/* Close SDL (prevents the ticks to continue running) */
	TTF_Quit();
	SDL_Quit();
}

void tsnh_expose_video(void)
{
	if (SDL_MUSTLOCK(displayer_test_sdl_status.screen))
		SDL_LockSurface(displayer_test_sdl_status.screen);

	lyrics_draw_solid(displayer_test_sdl_status.screen);

	if (SDL_MUSTLOCK(displayer_test_sdl_status.screen))
		SDL_UnlockSurface(displayer_test_sdl_status.screen);

	SDL_UpdateRect(displayer_test_sdl_status.screen, 0, 0, 0, 0);
}

void tsnh_key_down(void *pEvent)
{
	SDL_KeyboardEvent* pKeyEvent = (SDL_KeyboardEvent*)pEvent;
	gint key = pKeyEvent->keysym.sym;
	gint mod = pKeyEvent->keysym.mod;
	gint volume, value;

	#ifdef CODEDEBUG
	DEBUG(("test_sdl_handlers.cpp [tsnh_key_down]\n"));
	#endif

	switch (key) {
	case SDLK_ESCAPE:
	case SDLK_q:
		if (displayer_test_sdl_status.is_fullscreen)
			{ CreateScreen(640, 480, !displayer_test_sdl_status.is_fullscreen); }

		gtk_idle_add (displayer_test_sdl_disable_func, NULL);
		break;
	case SDLK_a:
		if ((mod & KMOD_CTRL) && !displayer_test_sdl_status.is_fullscreen) {
			GDK_THREADS_ENTER();
			singit_remote_show_about_dlg
				(test_sdl_dp.singit_session);
			GDK_THREADS_LEAVE();
		}
		break;
	case SDLK_b:
		xmms_remote_playlist_next(test_sdl_dp.xmms_session);
		break;
	case SDLK_c:
		if ((mod & KMOD_CTRL) && !displayer_test_sdl_status.is_fullscreen) {
//			GDK_THREADS_ENTER();
//			displayer_sdl_config_show();
//			GDK_THREADS_LEAVE();
		}
		else { xmms_remote_pause(test_sdl_dp.xmms_session); }
		break;
	case SDLK_e:
		if ((mod & KMOD_CTRL) && !displayer_test_sdl_status.is_fullscreen) {
			GDK_THREADS_ENTER();
			singit_remote_show_editor_dlg
				(test_sdl_dp.singit_session);
			GDK_THREADS_LEAVE();
		}
		break;
	case SDLK_i:
		if ((mod & KMOD_CTRL) && !displayer_test_sdl_status.is_fullscreen) {
			GDK_THREADS_ENTER();
			singit_remote_show_tag_manager_dlg
				(test_sdl_dp.singit_session);
			GDK_THREADS_LEAVE();
		}
		break;
	case SDLK_p:
		if ((mod & KMOD_CTRL) && !displayer_test_sdl_status.is_fullscreen) {
			GDK_THREADS_ENTER();
			singit_remote_show_prefs_dlg
				(test_sdl_dp.singit_session);
			GDK_THREADS_LEAVE();
		}
		break;
	case SDLK_v:
		xmms_remote_stop(test_sdl_dp.xmms_session);
		break;
	case SDLK_x:
		xmms_remote_play(test_sdl_dp.xmms_session);
		break;
	case SDLK_y:
		if (displayer_test_sdl_status.toggle_yz)
			{ xmms_remote_playlist_prev(test_sdl_dp.xmms_session); }
		break;
	case SDLK_z:
		if (!displayer_test_sdl_status.toggle_yz)
			{ xmms_remote_playlist_prev(test_sdl_dp.xmms_session); }
		break;
	case SDLK_KP_PLUS:
		volume = xmms_remote_get_main_volume(test_sdl_dp.xmms_session);
		if (volume < 100) { volume++; }
		xmms_remote_set_main_volume(test_sdl_dp.xmms_session, volume);
		break;
	case SDLK_KP_MINUS:
		volume = xmms_remote_get_main_volume(test_sdl_dp.xmms_session);
		if (volume > 0) { volume--; }
		xmms_remote_set_main_volume(test_sdl_dp.xmms_session, volume);
		break;
	case SDLK_RETURN:
	case SDLK_KP_ENTER:
		if (mod & KMOD_ALT) {
			if (CreateScreen(640, 480, !displayer_test_sdl_status.is_fullscreen) == TRUE) {
				SDL_ShowCursor(displayer_test_sdl_status.is_fullscreen ? SDL_DISABLE : SDL_ENABLE);
				lyrics_resize();
			}
			break;
		}
		if ((displayer_test_sdl_status.jump_to_song == 0) ||
			(key == SDLK_RETURN)) { break; }
		if (xmms_remote_get_playlist_pos(test_sdl_dp.xmms_session) !=
			(displayer_test_sdl_status.jump_to_song - 1)) {
		xmms_remote_set_playlist_pos
			(test_sdl_dp.xmms_session, (displayer_test_sdl_status.jump_to_song - 1));
		}
	case SDLK_KP_PERIOD:
		displayer_test_sdl_status.jump_to_song = 0;
		break;
	case SDLK_KP0:
	case SDLK_KP1:
	case SDLK_KP2:
	case SDLK_KP3:
	case SDLK_KP4:
	case SDLK_KP5:
	case SDLK_KP6:
	case SDLK_KP7:
	case SDLK_KP8:
	case SDLK_KP9:
	case SDLK_0:
	case SDLK_1:
	case SDLK_2:
	case SDLK_3:
	case SDLK_4:
	case SDLK_5:
	case SDLK_6:
	case SDLK_7:
	case SDLK_8:
	case SDLK_9:
		value = key - SDLK_0;
		if (value < 0 || value > 9)
		value = key - SDLK_KP0;

		if (mod & KMOD_CTRL) {
			GDK_THREADS_ENTER();
			enable_plugin(((value + 9) % 10));
			GDK_THREADS_LEAVE();
		}
		else {
			displayer_test_sdl_status.jump_to_song =
				(displayer_test_sdl_status.jump_to_song * 10) + value;
			if (displayer_test_sdl_status.jump_to_song > xmms_remote_get_playlist_length(test_sdl_dp.xmms_session))
				{ displayer_test_sdl_status.jump_to_song = value; }
		}
		break;
	default:
		// printf("%x - %x\n", event->state, event->keyval);
//		g_print("%i\n", key);
		break;
        }
}

void tsnh_resize(void *pEvent)
{
	SDL_ResizeEvent* pResizeEvent = (SDL_ResizeEvent*) pEvent;

	if ((displayer_test_sdl_status.is_fullscreen == FALSE) &&
		(CreateScreen(pResizeEvent->w, pResizeEvent->h, FALSE) == TRUE))
	{
		lyrics_resize();
	}
}

void tsnh_active(void *pEvent)
{
	if (displayer_test_sdl_status.is_fullscreen == TRUE) {
		GDK_THREADS_ENTER();
		sdl_helper_gain_focus();
		GDK_THREADS_LEAVE();
	}
}
