/*

This file is base on a file from XOSD :
Copyright (c) 2001 Andre Renaud (andre@ignavus.net)

It has been modified by Nicolas Adenis-Lamarre (aspegic500@free.fr) for Singit

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gtk/gtk.h>

#include "dlg_config.h"
#include "dlg_font.h"
#include "xosd.h"

#include "displayer_xosd_config.h"
#include "singit/macros.h"
#include "singit/wgt_colorbutton.h"

#include "displayer_xosd_status.h"
#include "displayer_xosd_config.h"

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "bottom-left.xpm"
#include "bottom-right.xpm"
#include "bottom.xpm"
#include "centre.xpm"
#include "left.xpm"
#include "right.xpm"
#include "top-left.xpm"
#include "top-right.xpm"
#include "top.xpm"

typedef struct _XosdDlgConfig {

	GtkWidget *configure_win, *color_dialog_window, *font_dialog_window;
	GtkWidget *font_entry, *color_entry;
	GtkWidget *positions[3][3];
	GtkWidget *v_offset_spin, *h_offset_spin, *shadow_offset_spin;
	GtkWidget *normalTextColor_button, *font_set_button;
	GtkWidget *force_globals_check_button;

	guchar color[3]; /* red, green, blue */
}
XosdDlgConfig;

XosdDlgConfig *config = NULL;

static XosdDlgConfig* XosdDlgConfig_new(void);
void XosdDlgConfig_destroy(XosdDlgConfig *xosddlgconfig);
void displayer_xosd_config_force_globals_toggle_event
	(GtkToggleButton *toggleButton,	gpointer data);

/*
 * Apply changed from configuration dialog.
 */
static void
configure_apply_cb (void *data)
{
	XosdConfigData *ccd;
	gchar tmp[13]; /* 13 because of the size of the color storage : 'rgb:xx/xx/xx' */

	g_return_if_fail(config->configure_win != NULL);
	g_return_if_fail(GTK_WIDGET_REALIZED(config->configure_win));
	g_return_if_fail(STATUS != NULL);
	g_return_if_fail(STATUS->m_config != NULL);

	ccd = GET_DCC;

	g_free(ccd->lyricFontName);
	g_free(ccd->normalTextColor);

	ccd->lyricFontName = gtk_editable_get_chars(GTK_EDITABLE(config->font_entry), 0, -1);
	ccd->shadow_offset = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (config->shadow_offset_spin));
	ccd->v_offset = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (config->v_offset_spin));
	ccd->h_offset = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (config->h_offset_spin));

#define GET_RGB_AS_STRING(a,b) { sprintf(tmp, "rgb:%.2x/%.2x/%.2x", \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[0], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[1], \
		(gushort) ((guchar *) (COLOR_BUTTON(a)->color))[2]); \
	 					b = g_strdup(tmp); }

	GET_RGB_AS_STRING(config->normalTextColor_button, ccd->normalTextColor);
#undef GET_RGB_AS_STRING

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_top][XOSD_left]))){
		ccd->position = XOSD_top;
		ccd->alignement = XOSD_left;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_top][XOSD_center]))){
		ccd->position = XOSD_top;
		ccd->alignement = XOSD_center;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_top][XOSD_right]))){
		ccd->position = XOSD_top;
		ccd->alignement = XOSD_right;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_middle][XOSD_left]))){
		ccd->position = XOSD_middle;
		ccd->alignement = XOSD_left;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_middle][XOSD_center]))){
		ccd->position = XOSD_middle;
		ccd->alignement = XOSD_center;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_middle][XOSD_right]))){
		ccd->position = XOSD_middle;
		ccd->alignement = XOSD_right;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_bottom][XOSD_left]))){
		ccd->position = XOSD_bottom;
		ccd->alignement = XOSD_left;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_bottom][XOSD_center]))){
		ccd->position = XOSD_bottom;
		ccd->alignement = XOSD_center;
	}
	else if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (config->positions[XOSD_bottom][XOSD_right]))){
		ccd->position = XOSD_bottom;
		ccd->alignement = XOSD_right;
	}

	ccd->forceGlobals = GTK_TOGGLE_BUTTON(config->force_globals_check_button)->active;

	singit_config_gen_emit_update(STATUS->m_config);
	singit_config_gen_save(STATUS->m_config);
}

/*
 * Apply changes and close configuration dialog.
 */
static void
configure_ok_cb (gpointer data)
{
	configure_apply_cb (data);

	XosdDlgConfig_destroy(config);
}

/* "position_icons_default" -- Load the default display position icons
 *
 * DESCRIPTION
 *		There are nine icons used to set the position of the XOSD
 *		window: one for each compass point and one for the center.
 *		"position_icons_default" loads teh default icons embedded
 *                                  into the displayer plugin.
 *
 * ARGUMENTS
 *		None.
 *
 * RETURNS
 *		An array of nine (9, 00001011, IX) GtkPixmap widgets.
 *
 * DEPENDS
 *		Libraries: gtk, gdk-pixbuf, stdlib, stdio
 *		CPP Definitions: XMMS_PIXMAPDIR
 */
static GtkWidget **
position_icons_default (GtkWidget* main_window)
{
	GtkWidget **icons = NULL;

	GdkPixmap *icon = NULL;
	GdkBitmap *mask = NULL;

	// Create the array to hold the icons
	icons = calloc (9, sizeof (GtkWidget *));
	if (icons == NULL)
	{
		return NULL;
	}

	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) top_left_xpm);
	icons[0] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) top_xpm);
	icons[1] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) top_right_xpm);
	icons[2] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) left_xpm);
	icons[6] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) centre_xpm);
	icons[7] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) right_xpm);
	icons[8] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) bottom_left_xpm);
	icons[3] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) bottom_xpm);
	icons[4] = gtk_pixmap_new(icon, mask);
	icon = gdk_pixmap_create_from_xpm_d
		(main_window->window, &mask, &main_window->style->white,
		(gchar**) bottom_right_xpm);
	icons[5] = gtk_pixmap_new(icon, mask);

	return icons;
}

/*
 * Create dialog window for configuration.
 */
void
dlg_config_main(void)
{
	GtkObject *v_offset_obj, *h_offset_obj, *s_offset_obj;
	GtkWidget *unit_label, *notebook_inside,
		*vbox, *hbox, *ok, *cancel, *apply, *notebook,
		*label, **position_icons, *position_table, *sep, *alignement;
	XosdConfigData *ccd;
	xosd_pos curr_pos;
	xosd_align curr_align;
	GSList *group = NULL;
	GdkColor gdk_color;

	/* read configuration */
	if (config && config->configure_win) {
		gdk_window_raise(config->configure_win->window);
		return;
	}

	g_return_if_fail(xosd_status_ref() != NULL);

	/* ************************** */
	/* construction of the window */
	/* ************************** */

	if( (config=XosdDlgConfig_new()) == NULL) {
		xosd_status_unref(NULL);
		return;
	}

	ccd = GET_DCC;

	config->configure_win = gtk_window_new (GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (config->configure_win), "destroy",
		GTK_SIGNAL_FUNC (gtk_widget_destroyed), &config->configure_win);
	gtk_window_set_title (GTK_WINDOW (config->configure_win),
		"OSD Plugin " DISPLAYER_XOSD_VERSION " - Configuration");
	gtk_widget_realize(config->configure_win);

	position_icons = position_icons_default(config->configure_win);

	/* The Main table to pack everything into */
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (config-> configure_win), vbox);

	/* force globals */
	config->force_globals_check_button = gtk_check_button_new_with_label(_("Force global settings"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(config->force_globals_check_button), ccd->forceGlobals);
	gtk_signal_connect(GTK_OBJECT(config->force_globals_check_button), "toggled", GTK_SIGNAL_FUNC(displayer_xosd_config_force_globals_toggle_event), NULL);
	sep=gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), config->force_globals_check_button, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), sep, TRUE, FALSE, 0);

	/* notebook */
	notebook=gtk_notebook_new();
	gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, FALSE, 0);

	/* Font */
	notebook_inside=gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(notebook_inside), 10);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), notebook_inside, gtk_label_new(_("Font")));

	/* Font selector */
	hbox=gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start (GTK_BOX (notebook_inside), hbox, TRUE, FALSE, 0);

	label = gtk_label_new (_("Font :"));
	config->font_entry = gtk_entry_new ();
	gtk_entry_set_text (GTK_ENTRY (config->font_entry), ccd->lyricFontName);
	config->font_set_button = gtk_button_new_with_label (_("Set..."));
	gtk_signal_connect (GTK_OBJECT (config->font_set_button), "clicked", GTK_SIGNAL_FUNC (font_dialog_window), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), config->font_entry, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), config->font_set_button, TRUE, FALSE, 0);


	/* Color Selector */
	gdk_color_parse(ccd->normalTextColor, &gdk_color);
	config->color[0] = gdk_color.red;
	config->color[1] = gdk_color.green;
	config->color[2] = gdk_color.blue;

	hbox=gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start (GTK_BOX (notebook_inside), hbox, TRUE, FALSE, 0);

	label = gtk_label_new (_("Normal Text Color :"));
	config->normalTextColor_button = color_button_new(_("Normal Text Color :"), 60, 20, config->color, 3);
	gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), config->normalTextColor_button, TRUE, FALSE, 0);


	/* Position */
	position_table = gtk_table_new (3, 3, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(position_table), 10);
	gtk_table_set_row_spacings(GTK_TABLE(position_table), 3);
	gtk_table_set_col_spacings(GTK_TABLE(position_table), 3);
	alignement = gtk_alignment_new(1.0, 1.0, 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(alignement), position_table);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), alignement, gtk_label_new(_("Alignement")));

	curr_pos = XOSD_top;
	for (curr_align = XOSD_left; curr_align <= XOSD_right; curr_align++)
		{
			config->positions[curr_pos][curr_align] = gtk_radio_button_new (group);
			gtk_container_add (GTK_CONTAINER(config->positions[curr_pos][curr_align]), position_icons[(curr_pos*3) + curr_align]);

			gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), FALSE);
			group = gtk_radio_button_group (GTK_RADIO_BUTTON (config->positions[curr_pos][curr_align]));

			if (ccd->position == curr_pos && ccd->alignement == curr_align)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), TRUE);

			gtk_table_attach (GTK_TABLE (position_table), config->positions[curr_pos][curr_align],
			curr_align, curr_align + 1, curr_pos, curr_pos + 1, GTK_FILL, GTK_FILL, 0, 0);
		}

	curr_pos = XOSD_middle;
	for (curr_align = XOSD_left; curr_align <= XOSD_right; curr_align++)
		{
			config->positions[curr_pos][curr_align] = gtk_radio_button_new (group);
			gtk_container_add (GTK_CONTAINER (config->positions[curr_pos][curr_align]), position_icons[(curr_pos*3) + curr_align]);

			gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), FALSE);
			group = gtk_radio_button_group (GTK_RADIO_BUTTON (config->positions[curr_pos][curr_align]));

			if (ccd->position == curr_pos && ccd->alignement == curr_align)
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), TRUE);

			gtk_table_attach (GTK_TABLE (position_table), config->positions[curr_pos][curr_align],
			curr_align, curr_align + 1, 1, 2, GTK_FILL, GTK_FILL, 0, 0);
		}

	curr_pos = XOSD_bottom;
	for (curr_align = XOSD_left; curr_align <= XOSD_right; curr_align++)
		{
			config->positions[curr_pos][curr_align] = gtk_radio_button_new (group);
			gtk_container_add (GTK_CONTAINER (config->positions[curr_pos][curr_align]), position_icons[(curr_pos*3) + curr_align]);

			gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), FALSE);
			group = gtk_radio_button_group (GTK_RADIO_BUTTON (config->positions[curr_pos][curr_align]));

			if (ccd->position == curr_pos && ccd->alignement == curr_align)
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (config->positions[curr_pos][curr_align]), TRUE);

			gtk_table_attach (GTK_TABLE (position_table),
			config->positions[curr_pos][curr_align],
			curr_align, curr_align + 1, 2, 3, GTK_FILL, GTK_FILL, 0, 0);
		}


	/* offsets */
	notebook_inside=gtk_table_new(3, 3, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(notebook_inside), 10);
	gtk_table_set_row_spacings(GTK_TABLE(notebook_inside), 10);
	gtk_table_set_col_spacings(GTK_TABLE(notebook_inside), 10);
	alignement = gtk_alignment_new(1.0, 1.0, 0.5, 0.5);
	gtk_container_add(GTK_CONTAINER(alignement), notebook_inside);
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), alignement, gtk_label_new(_("Offsets")));

	/* Vertical Offset */
	label = gtk_label_new (_("Vertical offset :"));
	gtk_table_attach (GTK_TABLE (notebook_inside), label, 0, 1, 0, 1, 0, 0, 0, 0);
	v_offset_obj = gtk_adjustment_new (ccd->v_offset, 0, 500, 1, 1, 1);
	config->v_offset_spin = gtk_spin_button_new (GTK_ADJUSTMENT (v_offset_obj), 1.0, 0);
	gtk_table_attach (GTK_TABLE (notebook_inside), config->v_offset_spin, 1, 2, 0, 1, 0, 0, 0, 0);
	unit_label = gtk_label_new (_("pixels"));
	gtk_table_attach (GTK_TABLE (notebook_inside), unit_label, 2, 3, 0, 1, 0, 0, 0, 0);

	/* Horizontal Offset */
	label = gtk_label_new (_("Horizontal offset :"));
	gtk_table_attach (GTK_TABLE (notebook_inside), label, 0, 1, 1, 2, 0, 0, 0, 0);
	h_offset_obj = gtk_adjustment_new (ccd->h_offset, 0, 500, 1, 1, 1);
	config->h_offset_spin = gtk_spin_button_new (GTK_ADJUSTMENT (h_offset_obj), 1.0, 0);
	gtk_table_attach (GTK_TABLE (notebook_inside), config->h_offset_spin, 1, 2, 1, 2, 0, 0, 0, 0);
	unit_label = gtk_label_new (_("pixels"));
	gtk_table_attach (GTK_TABLE (notebook_inside), unit_label, 2, 3, 1, 2, 0, 0, 0, 0);

	/* Shadow Offset */
	label = gtk_label_new (_("Shadow offset :"));
	gtk_table_attach (GTK_TABLE (notebook_inside), label, 0, 1, 2, 3, 0, 0, 0, 0);
	s_offset_obj = gtk_adjustment_new (ccd->shadow_offset, 0, 60, 1, 1, 1);
	config->shadow_offset_spin = gtk_spin_button_new (GTK_ADJUSTMENT (s_offset_obj), 1.0, 0);
	gtk_table_attach (GTK_TABLE (notebook_inside), config->shadow_offset_spin, 1, 2, 2, 3, 0, 0, 0, 0);
	unit_label = gtk_label_new (_("pixels"));
	gtk_table_attach (GTK_TABLE (notebook_inside), unit_label, 2, 3, 2, 3, 0, 0, 0, 0);

	/* separator */
	sep = gtk_hseparator_new ();
	gtk_box_pack_start (GTK_BOX (vbox), sep, FALSE, FALSE, 0);

	/* Command Buttons */
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (vbox), hbox, TRUE, FALSE, 0);

	ok = gtk_button_new_with_label (_("Ok"));
	gtk_signal_connect (GTK_OBJECT (ok), "clicked", GTK_SIGNAL_FUNC (configure_ok_cb), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), ok, TRUE, TRUE, 0);

	apply = gtk_button_new_with_label (_("Apply"));
	gtk_signal_connect (GTK_OBJECT (apply), "clicked", GTK_SIGNAL_FUNC (configure_apply_cb), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), apply, TRUE, TRUE, 0);

	cancel = gtk_button_new_with_label (_("Cancel"));
	gtk_signal_connect_object (GTK_OBJECT (cancel), "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy), GTK_OBJECT (config->configure_win));
	gtk_box_pack_start (GTK_BOX (hbox), cancel, TRUE, TRUE, 0);

	displayer_xosd_config_force_globals_toggle_event
		(GTK_TOGGLE_BUTTON(config->force_globals_check_button), NULL);

	gtk_widget_show_all (config->configure_win);
}

static XosdDlgConfig* XosdDlgConfig_new(void) {

	XosdDlgConfig *xosddlgconfig;

	if( (xosddlgconfig=(XosdDlgConfig *)malloc(sizeof(XosdDlgConfig))) == NULL)
		return NULL;

	return xosddlgconfig;
}

void XosdDlgConfig_destroy(XosdDlgConfig *xosddlgconfig){
	gtk_widget_destroy (xosddlgconfig->configure_win);
	free(config);
	config=NULL;
}

void dlg_config_main_set_font(gchar *font){
	gtk_entry_set_text (GTK_ENTRY (config->font_entry), font);
}

gchar* dlg_config_main_get_font(void) {

	gchar *tmp_font;

	tmp_font=g_strdup (gtk_entry_get_text (GTK_ENTRY (config->font_entry)));
	return tmp_font;
}

void displayer_xosd_config_force_globals_toggle_event
	(GtkToggleButton *toggleButton, gpointer data)
{
	gboolean state = !gtk_toggle_button_get_active(toggleButton);

	gtk_widget_set_sensitive(config->font_entry, state);
	gtk_widget_set_sensitive(config->font_set_button, state);
	gtk_widget_set_sensitive(config->normalTextColor_button, state);
}
