
#include "CEgErr.h"

#include "CStrNode.h"

CEgErr::CEgErr( long inErr )
	: mErr( inErr ), mOSErr( 0 )
{
}

bool CEgErr::noErr() {

	return (mErr == cNoErr);
}

long CEgErr::peekErr() {

	return mErr;
}

void CEgErr::throwErr( long inErr ) {

	if ( noErr() || inErr == cNoErr ) {
		mErr = inErr;
	}
}

long CEgErr::catchErr()
{
	long error = mErr;

	if (mErr != cNoErr)
		{ mErr = cNoErr; }

	return error;
}

void CEgErr::getErrStr( UtilStr& outStr ) {

	long err;
//	bool handled = false;
	
	if ( mOSErr ) {
		err = mOSErr;  
		OSErrMsg( outStr );
	}
	else {
		err = peekErr();
		switch ( err ) {

		case cNoErr:
			outStr.Append( "No error." );
			break;

		case cBadPLVersion:
		case cBadExamVersion:
			outStr.Append( "This file was made with a different version of Examgen or is damaged and cannot be opened." );
			break;				

		case cCorrupted:
			outStr.Append( "This file appears to be corrupt." );
			break;

		case cFileNotFound:
			outStr.Append( "File not found." );
			break;

		case cEOFErr:
			outStr.Append( "End of file reached." );
			break;

		case cEOSErr:
			outStr.Append( "End of file/stream reached." );
			break;

		case cBitmapCorrupted:
			outStr.Append( "The bitmap information is corrupt." );
			break;

		case cBitmapTooDeep:
			outStr.Append( "The bitmap must be 256 or less colors." );
			break;

		case cBitmapNotMono:
			outStr.Append( "The bitmap must be monochrome." );
			break;

		case cBadBitmapType:
			outStr.Append( "The file is not a BMP file." );
			break;			

		case cRLENotSupported:
			outStr.Append( "Compressed BMPs are not supported." );
			break;	

		default:
			outStr.Append( "Internal error." );
			break;
		}
	}
	
	outStr.Append( " (" );
	outStr.Append( err );
	outStr.Append( ')' );
}

void CEgErr::OSErrMsg( UtilStr& ioStr )
{
	switch ( mOSErr ) {

		default:
			ioStr.Append( "OS Error" );
	}
}
