#include "StubPrefPackageClient.h"

#include "PrefPackage.h"
#include <string.h>

//#include "YourPrefPackageClassHere.h"


StubPrefPackageClient::StubPrefPackageClient() {
	mPrefPackage = 0;
	
	mParams.mBool = true;
	strcpy( mParams.mStr1, "this is the param 'str'" );
	strcpy( mParams.mStr2, "1234" );
}


void StubPrefPackageClient::EditMyPrefs() {

	mOrigParams = mParams;
	
//	mPrefPackage = new PutYourPrefPackageClassHere;
	mPrefPackage -> Init( this );
}


void StubPrefPackageClient::StopEditingPrefs() {

	if ( mPrefPackage )
		mPrefPackage -> Shutdown();
}


void StubPrefPackageClient::PrefWindowReady() {

	
}


void StubPrefPackageClient::PrefWindowGone( int inSaveChanges ) {
	delete mPrefPackage;
	mPrefPackage = 0;
	
	if ( ! inSaveChanges )
		mParams = mOrigParams;
}


void StubPrefPackageClient::SetParam( long inParamID, const char* inParam ) {
	
	switch ( inParamID ) {
	
		case 'flag':
			if ( *inParam )
				mParams.mBool = true;
			else
				mParams.mBool = false;
			break;
			
		case 'str':
			strncpy( mParams.mStr1, inParam, 100 );
			break;

		case 'str2':
			strncpy( mParams.mStr2, inParam, 100 );
			break;

	}
}




int StubPrefPackageClient::GetParam( long inParamID, int inOriginalParam, char* ioParamBuf, int inBufSize ) {
	int gotParam = true;
	ParamData* params = ( inOriginalParam ) ? &mOrigParams : &mParams;
	
	switch ( inParamID ) {
	
		case 'flag':
			if ( params -> mBool ) {
				ioParamBuf[ 0 ] = '1';
				ioParamBuf[ 1 ] = 0; }
			else
				ioParamBuf[ 0 ] = 0;
			break;
			
		case 'str':
			strncpy( ioParamBuf, params -> mStr1, inBufSize - 1 );
			break;

		case 'str2':
			strncpy( ioParamBuf, params -> mStr2, inBufSize - 1 );
			break;
			
		default:
			gotParam = false;
	}
	
	return gotParam;
}


