/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_CLIST_TIMESTAMPS_H__
#define __EDITOR_CLIST_TIMESTAMPS_H__

#include "editor_view.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_EDITOR_CLIST_TIMESTAMPS            (editor_clist_timestamps_get_type ())
#define EDITOR_CLIST_TIMESTAMPS(obj)            (GTK_CHECK_CAST ((obj), TYPE_EDITOR_CLIST_TIMESTAMPS, EditorClistTimestamps))
#define EDITOR_CLIST_TIMESTAMPS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_CLIST_TIMESTAMPS, EditorClistTimestampsClass))
#define IS_EDITOR_CLIST_TIMESTAMPS(obj)         (GTK_CHECK_TYPE ((obj), TYPE_EDITOR_CLIST_TIMESTAMPS))
#define IS_EDITOR_CLIST_TIMESTAMPS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_CLIST_TIMESTAMPS))

typedef struct _EditorClistTimestamps       EditorClistTimestamps;
typedef struct _EditorClistTimestampsClass  EditorClistTimestampsClass;

struct _EditorClistTimestamps
{
	SingitEditorView        sev;

	guint                   active_line;

	GtkWidget              *clist;
	GtkWidget              *scrolled_window;
};

struct _EditorClistTimestampsClass
{
	SingitEditorViewClass   parent_class;
};

GtkType    editor_clist_timestamps_get_type  (void);
GtkWidget *editor_clist_timestamps_new       (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __EDITOR_CLIST_TIMESTAMPS_H__
