/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __EDITOR_QUERY_PARSER_H__
#define __EDITOR_QUERY_PARSER_H__

#include <glib.h>

// Result types
enum {
	RES_UNDEF = 0,
	RES_LIST,
	RES_FORWARD,
	RES_LYRICS,
};

// Struct to collect all lyric relevant data
typedef struct _Lyrics {

	gint    db_id;
	gchar  *artist;
	gchar  *album;
	gchar  *title;
	gchar  *modified;
	gchar  *author;
	gchar **text;
}
Lyrics;

// * A struct to hold the possible result types
// * The result can be a
typedef struct _LyrixQueryResult {

	gint result_type;

	struct _list {
		guint     entries;
		GList    *lyrics;
		// Which is the next page of the result
		gint      pages;
	}
	list;

	struct _forward {
		gchar    *uri;
	}
	forward;

	// These may just be links inside the lyrics GList (list)
	// They must not be freed!
	struct _lyrics {
		Lyrics    lyric_data;
	}
	lyrics;

	gdouble lookup_dur;
	gint    status_code;
}
LyrixQueryResult;

typedef enum {
	PT_UDF = 0,		// Undefined
	PT_FIL = 1 << 0,	// Parse from file
	PT_BUF = 1 << 1,	// Parse from buffer
	PT_QUE = 1 << 2,	// Data is query result data
	PT_LYR = 1 << 3,	// Data is lyrics result data
	PT_XML = 1 << 4,	// Data is encodede in HTML / XML
	PT_TXT = 1 << 5,	// Data is encoded as text BLOB
}
ParseType;

LyrixQueryResult* lyrix_query_result_new(void);

void lyrix_query_result_free(LyrixQueryResult *res);

gboolean lyrix_query_result_parse(LyrixQueryResult* res,
	const gchar *buf, gint buf_len, ParseType type);

gchar *lyrix_query_result_get_cached_lyrics
	(LyrixQueryResult* res, gint db_id);

#define lyrix_query_result_parse_results(res, file) \
	lyrix_query_result_parse(res, file, -1, PT_FILE | PT_QUE)

#define lyrix_query_result_parse_lyrics(res, file) \
	lyrix_query_result_parse(res, file, -1, PT_FILE | PT_LYR)

#endif // __EDITOR_QUERY_PARSER_H__
