/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_EDITOR_VIEW_H__
#define __SINGIT_EDITOR_VIEW_H__

#include <gtk/gtkbin.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_SINGIT_EDITOR_VIEW            (singit_editor_view_get_type ())
#define SINGIT_EDITOR_VIEW(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_EDITOR_VIEW, SingitEditorView))
#define SINGIT_EDITOR_VIEW_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_EDITOR_VIEW, SingitEditorViewClass))
#define IS_SINGIT_EDITOR_VIEW(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_EDITOR_VIEW))
#define IS_SINGIT_EDITOR_VIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_EDITOR_VIEW))

typedef struct _SingitEditorView       SingitEditorView;
typedef struct _SingitEditorViewClass  SingitEditorViewClass;

struct _SingitEditorView
{
	GtkBin    bin;

	guint     cursor_text_offset;
	gboolean  modified;
};

struct _SingitEditorViewClass
{
	GtkBinClass parent_class;

	void   (* modified) (SingitEditorView *sev, gboolean modified);
	gchar* (* get_text) (SingitEditorView *sev);
	void   (* set_text) (SingitEditorView *sev, const gchar *text);
};

GtkType    singit_editor_view_get_type  (void);
GtkWidget* singit_editor_view_new       (void);

gchar*     singit_editor_view_get_text (SingitEditorView *ev, gint *char_offset);
void       singit_editor_view_set_text (SingitEditorView *ev, gchar *text, gint char_offset);

void       singit_editor_view_modify   (SingitEditorView *sev, gboolean modified);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __SINGIT_EDITOR_VIEW_H__
