/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_FILE_INFO_H__
#define __SINGIT_FILE_INFO_H__

#include <sys/stat.h>
#include "singit_sha.h"

typedef struct _SingitFileInfo {

	gchar        *name;
	struct stat   stats;
	guchar        sha_digest[SHA_DIGESTSIZE];
	
	gboolean      init;
}
SingitFileInfo;

SingitFileInfo* singit_file_info_new(gchar *filename, gboolean hash);

void singit_file_info_free(SingitFileInfo *info);
void singit_file_info_free_list(SingitFileInfo **infos);

gint singit_file_info_changed(SingitFileInfo* info, 
	struct stat *stats, FILE *handle, gboolean hash);

SingitFileInfo* singit_file_info_any_changed(SingitFileInfo **infos, gboolean hash);
	
gboolean singit_file_info_reset(SingitFileInfo *info, gboolean hash);
gboolean singit_file_info_reinit(SingitFileInfo *info, gchar *filename, gboolean hash);

#endif  // __SINGIT_FILE_INFO_H__
