/*
 *      $COPYRIGHT$
 *
 *      $Id: bhostparse.cc,v 1.2 2000/10/29 19:35:40 bbarrett Exp $
 *
 *	Function:	- boot schema parser
 *			- host file syntax version
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <lamnet.h>
#include <net.h>
#include <typical.h>
#include "bhostparse.h"

/*
 * constants
 */
#define MAXLINE		256	       /* input line size */
#define LNDBLOCK	10	       /* array allocation block */

/*
 * static variables
 */
static char linebuf[MAXLINE];

/*
 * static functions
 */
static void parseline(char **, char**);

/*
 *	parse_host
 *
 *	Function:	- parse a host file
 *			- fill the network description
 *			- node IDs are [0, N-1]
 *	Accepts:	- input file stream
 *			- node description array (value returned)
 *			- array size (value returned)
 */
int
bhostparse(FILE *fp, struct lamnode **plamnet, int *pnlamnet)
{
  char *host;			       /* host machine name */

  char *user;			       /* user name */

  int nlndalloc;		       /* current allocation size */

  int node;			       /* current node ID */

  struct lamnode *lamnet;	       /* current node desc. array */

/*
 * Loop till EOF reading and parsing line-by-line.
 */
  lamnet = 0;
  nlndalloc = 0;
  node = 0;

  while (!feof(fp)) {

    if (fgets(linebuf, MAXLINE, fp) == 0)
      break;
/*
 * Parse the line for hostname and username.
 */
    parseline(&host, &user);
/*
 * If a machine name is found, add the node to the network.
 */
    if (!host) {
      continue;
    }
/*
 * Allocate initial node description array.
 */
    if (lamnet == 0) {
      lamnet = (struct lamnode *) malloc((unsigned)
				      LNDBLOCK * sizeof(struct lamnode));
      if (lamnet == 0)
	return (LAMERROR);
      nlndalloc = LNDBLOCK;
    }
/*
 * Extend node description array.
 */
    if (nlndalloc <= node) {
      nlndalloc += LNDBLOCK;
      lamnet = (struct lamnode *) realloc((char *) lamnet,
					  (unsigned) nlndalloc *
					  sizeof(struct lamnode));
      if (lamnet == 0)
	return (LAMERROR);
    }
    lamnet[node].lnd_nodeid = node;
    lamnet[node].lnd_type = NT_BOOT;
/*
 * Set host name.
 */
    lamnet[node].lnd_hname = (char*) malloc((unsigned) strlen(host) + 1);
    if (lamnet[node].lnd_hname == 0)
      return (LAMERROR);
    strcpy(lamnet[node].lnd_hname, host);
/*
 * Set optional user name.
 */
    lamnet[node].lnd_uname = 0;

    if (user) {
      lamnet[node].lnd_uname = (char*) malloc((unsigned)
				      strlen(user) + 1);
      if (lamnet[node].lnd_uname == 0)
	return (LAMERROR);
      strcpy(lamnet[node].lnd_uname, user);
    }
    node++;
  }

  *pnlamnet = node;
  *plamnet = lamnet;
  return (0);
}

/*
 *	parseline
 *
 *	Function:	- parses the line buffer for hostname and username
 *			- Format: hostname [username]
 *			- skip comments: everything after a # character
 *			- fills hostname/username or NULL
 *	Accepts:	- host name (returned value)
 *			- user name (returned value)
 */
static void
parseline(char **phost, char **puser)
{
  char *p;			       /* favourite pointer */

  *phost = 0;
  *puser = 0;
  linebuf[MAXLINE - 1] = '\0';
/*
 * Skip comments by replacing the first '#' with a NULL.
 */
  for (p = linebuf; *p; ++p) {

    if (*p == '#') {
      *p = '\0';
      break;
    }
  }
/*
 * Find beginning and end of hostname and null-terminate it.
 */
  for (p = linebuf; *p; ++p) {

    if (!isspace((int) *p)) {
      *phost = p;
      break;
    }
  }

  for (; *p; ++p) {

    if (isspace((int) *p)) {
      *p++ = '\0';
      break;
    }
  }
/*
 * Find beginning and end of username and null-terminate it.
 */
  for (; *p; ++p) {

    if (!isspace((int) *p)) {
      *puser = p;
      break;
    }
  }

  for (; *p; ++p) {

    if (isspace((int) *p)) {
      *p++ = '\0';
      break;
    }
  }
}
