/*
 *      $COPYRIGHT$
 *
 *	$Id: itoa.cc,v 1.1 2000/02/07 23:06:02 bbarrett Exp $
 *
 *	Function:	- K&R itoa()
 */

#include <string.h>
#include "itoa.h"

/*
 * local functions
 */
static void reverse(char*);

void
sfh_itoa(int n, char *s)
{
  int i;

  int sign;

  if ((sign = n) < 0)
    n = -n;

  i = 0;

  do {
    s[i++] = n % 10 + '0';
  } while ((n /= 10) > 0);

  if (sign < 0)
    s[i++] = '-';

  s[i] = '\0';
  reverse(s);
}

/*
 *	reverse
 *
 *	Function:	- reverse string in place
 *	Accepts:	- string
 */
static void
reverse(char *s)
{
  int c;

  int i;

  int j;

  for (i = 0, j = strlen(s) - 1; i < j; i++, j--) {
    c = s[i];
    s[i] = s[j];
    s[j] = c;
  }
}

/*
 * backwards compatibility
 */
void 
itoa(int n, char *s)
{
  sfh_itoa(n, s);
}
