/*
 *      $COPYRIGHT$
 *
 *	$Id: sfh.h,v 1.4 2000/02/07 23:06:05 bbarrett Exp $
 *
 *	Function:	- constants, templates and prototypes
 */

#ifndef _SFH_H
#define _SFH_H

#include <xmpi_config.h>
#include <sys/types.h>
#include <netinet/in.h>

#ifdef __cplusplus
extern "C" {
#endif

extern void	sfh_itoa __ARGS((int, char *));

extern int	sfh_argv_add __ARGS((int *, char ***, char *));
extern int	sfh_argv_count __ARGS((char **));
extern void	sfh_argv_free __ARGS((char **));
extern char	**sfh_argv_break __ARGS((const char *, int));
extern char	**sfh_argv_dup __ARGS((char **));
extern char	*sfh_argv_glue __ARGS((char **, int, unsigned int));
extern unsigned int sfh_argv_len __ARGS((char **));
extern char 	**sfh_argv_break_quoted __ARGS((char *, int, char[]));
extern char	*sfh_argv_quote __ARGS((const char *, char[]));

extern char	*sfh_path_find __ARGS((char *, char **, int));
extern char	*sfh_path_env_find __ARGS((char *, int));
extern char	*sfh_path_findv __ARGS((char *, char **, int, char **));
extern char	*sfh_path_env_findv __ARGS((char *, int, char **, char *));

extern int	sfh_sock_open_srv_inet_stm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_stm __ARGS((unsigned char *, int));
extern int	sfh_sock_open_srv_unix_stm __ARGS((char *));
extern int	sfh_sock_open_clt_unix_stm __ARGS((char *));
extern int	sfh_sock_accept_tmout __ARGS((int, int));
extern int	sfh_sock_open_srv_inet_dgm __ARGS((int *));
extern int	sfh_sock_open_clt_inet_dgm __ARGS((void));
extern void	sfh_sock_fill_inet_addr __ARGS((unsigned char *, int,
						struct sockaddr_in *));
extern int	sfh_send_fd __ARGS((int, int));
extern int	sfh_recv_fd __ARGS((int));

#ifdef __cplusplus
}
#endif

#endif	/* _SFH_H */
