/*
 *   XPP - The X Printing Panel
 *   --------------------------
 *
 *   Implementation of the "Input_Slider" class which is a widget to 
 *   enter numerical values by both an input field and a slider.
 *
 *   Copyright 2000 by Till Kamppeter
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of the
 *   License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *   02111-1307  USA
 *
 */

#include "config.h"
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <math.h>
#include "inputslider.h"

Input_Slider::Input_Slider(int x,int y,int w,int h, const char*l)
    : Fl_Group(x,y,w,h,l) {
  // The default orientation of the slider is vertical, so set initial
  // coordinates for a vertical slider
  int sxx = x, syy = y, sww = w, shh = h;
  int ixx = x, iyy = y, iww = w, ihh = h;
  syy += 30; ihh = 25; shh -= 30;
  // set up the input field
  inputfield_ = new Fl_Value_Input(ixx,iyy,iww,ihh);
  inputfield_->box(FL_DOWN_BOX);
  inputfield_->textfont(FL_HELVETICA);
  inputfield_->textsize(10);
  inputfield_->textcolor(FL_BLACK);
  inputfield_->cursor_color(FL_BLACK);
  inputfield_->step(0); // Allow cut & paste for the entered value
  inputfield_->soft(false); // True does not make sense in this
                            // combined input/slider widget
  inputfield_->user_data((void *)this); // needed by callback
  inputfield_->callback((Fl_Callback*)inputfield_cb);
  // set up the slider
  slider_ = new Fl_Slider(sxx,syy,sww,shh);
  slider_->minimum(inputfield_->minimum()); // sync parameters of the two
  slider_->maximum(inputfield_->maximum()); // fields
  slider_->step(inputfield_->step());
  slider_->value(inputfield_->value());
  slider_->user_data((void *)this); // needed by callback
  slider_->callback((Fl_Callback*)slider_cb);
  resizable(slider_);
  end();
}

inline void Input_Slider::slider_cbi(Fl_Slider* o, // From which widget
                                                   // we are called
                                       void* v)    // option to add
{
  inputfield_->value(o->value());
  inputfield_->redraw();
  do_callback();
}

void Input_Slider::slider_cb(Fl_Slider* o,    // From which widget
                                              // we are called
                               void* v)       // option to add
{
  ((Input_Slider*)(o->user_data()))->slider_cbi(o,v);
}


inline void Input_Slider::inputfield_cbi(Fl_Value_Input* o, 
                                                       // From which widget
                                                       // we are called
                                        void* v)       // option to add
{
  slider_->value(o->value());
  slider_->redraw();
  do_callback();
}

void Input_Slider::inputfield_cb(Fl_Value_Input* o, // From which widget
                                               // we are called
                               void* v)        // option to add
{
  ((Input_Slider*)(o->user_data()))->inputfield_cbi(o,v);
}
