/*

    xpuyopuyo - xpuyopuyo.c   Copyright(c) 1999-2003 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Main function
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>
#include <stdlib.h>
#include <config.h>
#include <pgame.h>
#include <pinfo.h>
#include <pwindow.h>


#if !HAVE_GETTIMEOFDAY
#error "This program requires gettimeofday()"
#endif


int main(int argc, char **argv) {

   pconfig *c;
   pwindow *w;

   p_info();
   
   /* Create game configuration, X window.
      Parse command line options, and load
      images.                              */   
   if(!(c = p_config_new(&argc, &argv))) return(1);
   if(!(w = p_window_new(c, argc, argv))) return(1);

   p_window_paint(c, w, P_REDRAW_ALL);
   
   p_config_initialise(c);

   p_window_run(w, c);
   
   /* Release all data */   
   p_window_free(&w);
   p_config_free(&c);

   return(0);

}
