/*
# X-BASED THREED
#
#  ThreedP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Threed */

#ifndef _ThreedP_h
#define _ThreedP_h

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <string.h>
#include "Threed.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a) /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->threed.memDC)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w,x1,y1,NULL); \
  (void)LineTo(w,x2,y2)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) \
  if (dr) w->threed.hOldBitmap = \
  (HBITMAP) SelectObject(w->threed.memDC,dr); \
  w->threed.hPen = CreatePen(PS_SOLID,1,c); \
  w->threed.hOldPen = (HPEN) SelectObject(DC(w,dr),w->threed.hPen); \
  LINE(DC(w,dr),x1,y1,x2,y2); \
  (void) SelectObject(DC(w,dr),w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen); \
  if (dr) (void) SelectObject(w->threed.memDC,w->threed.hOldBitmap)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->threed.hOldBitmap = \
  (HBITMAP) SelectObject(w->threed.memDC,dr); \
  w->threed.hPen = CreatePen(PS_SOLID,1,c); \
  w->threed.hOldPen = (HPEN) SelectObject(DC(w,dr),w->threed.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen); \
  if (dr) (void) SelectObject(w->threed.memDC,w->threed.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->threed.hOldBitmap = \
  (HBITMAP) SelectObject(w->threed.memDC,dr); \
  w->threed.hPen = CreatePen(PS_SOLID,1,c); \
  w->threed.hOldPen = (HPEN) SelectObject(DC(w,dr),w->threed.hPen); \
  w->threed.hBrush = CreateSolidBrush(c); \
  w->threed.hOldBrush = (HBRUSH) SelectObject(DC(w,dr), \
  w->threed.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->threed.hOldBrush); \
  (void) DeleteObject(w->threed.hBrush); \
  (void) SelectObject(DC(w,dr),w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen); \
  if (dr) (void) SelectObject(w->threed.memDC,w->threed.hOldBitmap)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w,x-r+1,y-r+1,x+r,y+r)
#define DRAWCIRCLE(w,dr,c,d,x,y) w->threed.hPen = CreatePen(PS_SOLID,1,c); \
  w->threed.hOldPen = (HPEN) SelectObject(DC(w,dr),w->threed.hPen); \
  CIRCLE(DC(w,dr),((d+1)>>1),x,y); \
  (void) SelectObject(DC(w,dr),w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define FILLCIRCLE(w,dr,c,d,x,y) w->threed.hPen = CreatePen(PS_SOLID,1,c); \
  w->threed.hOldPen = (HPEN) SelectObject(DC(w,dr),w->threed.hPen); \
  w->threed.hBrush = CreateSolidBrush(c); \
  w->threed.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->threed.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(DC(w,dr),w->threed.hOldBrush); \
  (void) DeleteObject(w->threed.hBrush); \
  (void) SelectObject(DC(w,dr),w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->threed.hOldBitmap = \
  (HBITMAP) SelectObject(w->threed.memDC,dr); \
  (void) SetTextColor(DC(w,dr),c); \
  (void) SetBkMode(DC(w,dr),TRANSPARENT); \
  (void) TextOut(DC(w,dr),(x)-3,(y)-11,(LPCSTR)s,l); \
  if (dr) (void) SelectObject(w->threed.memDC,w->threed.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyThreeD(HBRUSH brush);
extern void InitializeThreeD(ThreeDWidget w, HBRUSH brush);
extern void ExposeThreeD(const ThreeDWidget w);
extern void HideThreeD(const ThreeDWidget w);
extern void SelectThreeD(const ThreeDWidget w, const int x, const int y);
extern void MotionThreeD(const ThreeDWidget w, const int x, const int y);
extern void ReleaseThreeD(const ThreeDWidget w);
extern void SetSurfaceThreeD(ThreeDWidget w, int surface);
extern void SetObjectThreeD(ThreeDWidget w, int object3D);
extern void SetThreeD(ThreeDWidget w, int reason);

#else

#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Threed.h"

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWLINE(w,dr,c,x1,y1,x2,y2) XDrawLine(XtDisplay(w),DR(w,dr),\
  c,x1,y1,x2,y2)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWCIRCLE(w,dr,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),DR(w,dr),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define FILLCIRCLE(w,dr,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),DR(w,dr),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)
#define POLYGON(w,dr,c,lc,l,n,v,o) XFillPolygon(XtDisplay(w), DR(w,dr), c, \
  l, n, (v) ? Convex : Complex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), DR(w,dr), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)
#define POLYLINE(w,dr,c,l,n,o) XDrawLines(XtDisplay(w), DR(w,dr), c, \
  l, n,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _ThreeDClassPart {
	int ignore;
} ThreeDClassPart;

typedef struct _ThreeDClassRec {
	CoreClassPart core_class;
	ThreeDClassPart threed_class;
} ThreeDClassRec;

extern ThreeDClassRec threedClassRec;
#endif

#define SYMBOL '='

#define VIEWRATIO 4.0
#define DELTADEPTH 2
#define DELTADISTANCE 5
#define DELTADEGREES 5
#define COLORS 6
#define WHITE_BRUSH 0
#define LTGRAY_BRUSH 1
#define GRAY_BRUSH 2
#define DKGRAY_BRUSH 3
#define BLACK_BRUSH 4
#define ANOTHER_BRUSH 5
#define HIDDENSURFACEREMOVAL True
#define WIREFRAME False
#define MAXPOLYGONVERTICES 10 /* should not be here, but its reasonably high */

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

typedef double Matrix4x4[4][4]; /* the standard 4x4 homogeneous matrix */
typedef double Matrix1x4[4]; /* row vector */

typedef struct _Point3D {
	double x, y, z; /* 3D vector */
#if 0
	double w; /* normalization factor or 4D? */
#endif
} Point3D, Vector3D;

typedef struct _Vertex {
	Point3D eye;
	Point screen;
} Vertex;

typedef struct _Surface {
	int     numVertices; /* number of vertices in surface plane */
	int     mapIndex; /* maps surface to first vertex */
	int	color;
	int     shade;
	int     shading;
	int     visible;
	Boolean twoSided;
	Boolean clipped;
	Boolean active;
#ifdef DEPTHINDEX
	int     depthIndex;
#else
	double  averageDepth;
#endif
	double  normalLength;
} Surface;

typedef struct _Object3D {
	int         id;
	char       *name;
	int         numVertices;
	int         numSurfaces;
	int         numEdges; /* 2 * actual edges i.e. edges of each polygon */
	Point3D    *local; /* Vertex Array */
	Point3D    *world; /* Vertex Array */
	Surface    *surface; /* Points to Surface Map */
	int        *map; /* Points to Vertex Array */
	Vertex     *vertex; /* Vertex Array */
	Boolean     convex; /* Are all polygons convex? */
	double      radius; /* Maximum radius of object */
	int         state;
	Point3D     origin; /* Origin of object in world coordinates */
} Object3D;

typedef struct _ThreeDPart {
	IntPoint3D  distance;
	IntAngle3D  deltaAngle;
	IntAngle3D  angle;
	Boolean     sound;
	Boolean     mono, reverse, focus, surface;
	int         delay, numSlices;
	int         object, numObjects;
	char       *name;
	char      **list;
	Object3D   *objects;
	Position    size;
	Point       center, currentPosition;
	GC          frameGC, graphicsGC, borderGC, inverseGC;
	GC          shadeGC[COLORS];
	Pixmap      bufferObjects[2];
#ifdef WINVER
	long        oldTime;
	char        moveSound[81], picture[81];
	char        shadeChar[COLORS];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	int         menu, graphicsFormat;
	char       *moveSound, *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       shadeColor[COLORS];
	XtCallbackList select;
#endif
} ThreeDPart;

typedef struct _ThreeDRec {
	CorePart core;
	ThreeDPart threed;
} ThreeDRec;

void createVector3D(Point3D *init, Point3D *term, Point3D *result);
double magnitudeVector3D(Vector3D *v);
double dotProduct3D(Vector3D *u, Vector3D *v);
void crossProduct3D(Vector3D *u, Vector3D *v, Vector3D *normal);
double minimumObjectRadius(Object3D *obj);
double maximumObjectRadius(Object3D *obj);
void createTrigTables(void);
double sinInt(int angle);
double cosInt(int angle);
void rotateObject(Object3D *obj, IntAngle3D *angle);
Boolean pointInPolygon(Point *pt, Point *poly, int n);
#endif /* _ThreedP_h */
