/*-
# X-BASED PYRAMINX(tm)
#
#  PyraminxP.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Pyraminx */

#ifndef _PyraminxP_h
#define _PyraminxP_h

#include "xwin.h"
#include "timer.h"
#include "Pyraminx.h"

#ifdef WINVER
extern void DestroyPuzzle(HBRUSH brush);
extern void ResizePuzzle(PyraminxWidget w);
extern void SizePuzzle(PyraminxWidget w);
extern void InitializePuzzle(PyraminxWidget w, HBRUSH brush);
extern void ExposePuzzle(PyraminxWidget w);
extern void HidePuzzle(PyraminxWidget w);
extern void SelectPuzzle(PyraminxWidget w,
	const int x, const int y, const int control);
extern void ReleasePuzzle(PyraminxWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticePuzzle(PyraminxWidget w);
extern void RandomizePuzzle(PyraminxWidget w);
extern void GetPuzzle(PyraminxWidget w);
extern void WritePuzzle(PyraminxWidget w);
extern void UndoPuzzle(PyraminxWidget w);
extern void RedoPuzzle(PyraminxWidget w);
extern void ClearPuzzle(PyraminxWidget w);
extern void SolvePuzzle(PyraminxWidget w);
extern void IncrementPuzzle(PyraminxWidget w);
extern Boolean DecrementPuzzle(PyraminxWidget w);
extern void OrientizePuzzle(PyraminxWidget w);
extern void StickyModePuzzle(PyraminxWidget w);
extern void PeriodModePuzzle(PyraminxWidget w, const int mode);
extern void Period2ModePuzzle(PyraminxWidget w);
extern void Period3ModePuzzle(PyraminxWidget w);
extern void BothModePuzzle(PyraminxWidget w);
extern void EnterPuzzle(PyraminxWidget w);
extern void LeavePuzzle(PyraminxWidget w);
extern void MovePuzzleInput(PyraminxWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MovePuzzleDir(PyraminxWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _PyraminxClassPart {
	int         ignore;
} PyraminxClassPart;

typedef struct _PyraminxClassRec {
	CoreClassPart coreClass;
	PyraminxClassPart pyraminxClass;
} PyraminxClassRec;

extern PyraminxClassRec pyraminxClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BOTTOM 3
#define BL 4
#define LEFT 5
#define COORD 6
#define CW 7
#define CCW 11

#define MAXFACES 4
#define DOWN 0
#define UP 1
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

typedef struct _MoveRecord {
#if 0
	int face, direction, style, control;
#endif
	unsigned short int packed;  /* This makes assumptions on the data. */
	int position;		    /* Do not make assumptions on this one. */
} MoveRecord;

typedef struct _MoveStack {
	MoveRecord move;
	struct _MoveStack *previous, *next;
} MoveStack;

typedef struct _PyraminxStack {
	MoveStack *currMove, *lastMove, *firstMove;
	int count;
} PyraminxStack;

typedef struct _PyraminxLoc {
	int         face, rotation;
} PyraminxLoc;

typedef struct _PyraminxPart {
	PyraminxLoc *facetLoc[MAXFACES];
	PyraminxLoc *faceLoc[MAXSIDES];
	PyraminxLoc *rowLoc[3][MAXSIDES];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	Boolean     scoreOnly, versionOnly;
	int         size, sizeSize, mode;
	int         delay;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength;
	Position    sideOffset, orientLineLength, orientDiagLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} PyraminxPart;

typedef struct _PyraminxRec {
	CorePart    core;
	PyraminxPart pyraminx;
} PyraminxRec;

extern PyraminxLoc *startLoc[MAXFACES];
extern void setPuzzle(PyraminxWidget w, int reason);
extern void MovePuzzle(PyraminxWidget w, int face, int position,
	int direction, int style, int control);
extern void MovePuzzleDelay(PyraminxWidget w, int face, int position,
	int direction, int style, int control);

extern void SolveSomePieces(PyraminxWidget w);
extern void DrawAllPieces(PyraminxWidget w);
extern Boolean CheckSolved(PyraminxWidget w);
extern void newMoves(PyraminxStack *s);
extern void deleteMoves(PyraminxStack *s);
extern void setMove(PyraminxStack *s,
	int face, int position, int direction, int style, int control);
extern void getMove(PyraminxStack *s,
	int *face, int *position, int *direction, int *style, int *control);
extern int madeMoves(PyraminxStack *s);
extern void flushMoves(PyraminxWidget w, PyraminxStack *s, Boolean undo);
extern int numMoves(PyraminxStack *s);
extern void scanMoves(FILE *fp, PyraminxWidget w, int moves);
extern void printMoves(FILE *fp, PyraminxStack *s);
extern void scanStartPosition(FILE *fp, PyraminxWidget w);
extern void printStartPosition(FILE *fp, PyraminxWidget w);
extern void setStartPosition(PyraminxWidget w);

#endif /* _PyraminxP_h */
