/*
 * @(#)Dial.h
 *
 * Copyright 1994 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Dial */

#ifndef _Dial_h
#define _Dial_h

extern WidgetClass dialWidgetClass;
typedef struct _DialClassRec *DialWidgetClass;
typedef struct _DialRec *DialWidget;

#define XtNmono ((char *) "mono")
#define XtNpointerColor ((char *) "pointerColor")
#define XtNmarkerColor ((char *) "markerColor")
#define XtNmarkerLength ((char *) "markerLength")
#define XtNmarkers ((char *) "markers")
#define XtNangle ((char *) "angle")
#define XtNmaxDegree ((char *) "maxDegree")
#define XtNminimum ((char *) "minimum")
#define XtNmaximum ((char *) "maximum")
#define XtNfactor ((char *) "factor")
#define XtNval ((char *) "val")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCMarkers ((char *) "Markers")
#define XtCAngle ((char *) "Angle")
#define XtCMaxDegree ((char *) "MaxDegree")
#define XtCMinimum ((char *) "Minimum")
#define XtCMaximum ((char *) "Maximum")
#define XtCFactor ((char *) "Factor")
#define XtCVal ((char *) "Val")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")


typedef struct {
  int reason;
  XEvent *event;
  int val;
} dialCallbackStruct;

#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_SELECTED 201
#define ACTION_INCREMENT 300
#define ACTION_DECREMENT 301
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE

#define BOOL_STRING(a) ((a==0)?"false":"true")

#endif /* _Dial_h */
/* DON'T ADD STUFF AFTER THIS #endif */
