/*
 * @(#)RubikGLP.h
 *
 * Copyright 2003 - 2008  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for RubikGL */

#ifndef _RubikGLP_h
#define _RubikGLP_h

#include "RubikGL.h"
#include <GL/gl.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _RubikGLClassPart {
	int         ignore;
} RubikGLClassPart;

typedef struct _RubikGLClassRec {
	CoreClassPart coreClass;
	RubikClassPart rubikClass;
	RubikGLClassPart rubikGLClass;
} RubikGLClassRec;

extern RubikGLClassRec rubikGLClassRec;
#endif

#define TR 8
#define BR 9
#define BL 10
#define TL 11
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define COORD3D 12

#define AVSIZE ((w->rubik.sizex+w->rubik.sizey+w->rubik.sizez)/3.0)     /* Use of this should be minimized */
#define MAX_SIZEX w->rubik.sizex
#define MAX_SIZEY w->rubik.sizey
#define MAX_SIZEZ w->rubik.sizez
#define MAX_SIZEXY (w->rubik.sizex*w->rubik.sizey)
#define MAX_SIZEYZ (w->rubik.sizey*w->rubik.sizez)
#define MAX_SIZEZX (w->rubik.sizez*w->rubik.sizex)
#define LASTX (w->rubik.sizex-1)
#define LASTY (w->rubik.sizey-1)
#define LASTZ (w->rubik.sizez-1)
#define SCALE (2.1/AVSIZE)
/* These are not likely to change but... */
#define FIRSTX 0
#define FIRSTY 0
#define FIRSTZ 0
#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define NO_FACE (IGNORE_DIR)
#define TEST_FACE (MAX_FACES)
#define ERROR_FACE (MAX_FACES+1)
#define NO_POSITION (IGNORE_DIR)
#define NO_ROTATION (2*MAX_ORIENT)
#define NO_DEPTH (IGNORE_DIR)
#define REVX(a) (MAX_SIZEX-a-1)
#define REVY(a) (MAX_SIZEY-a-1)
#define REVZ(a) (MAX_SIZEZ-a-1)

#define CUBE_LENGTH 0.50
#define CUBE_ROUND (CUBE_LENGTH-0.05)
#define STICKER_LONG (CUBE_ROUND-0.05)
#define STICKER_SHORT (STICKER_LONG-0.05)
#define STICKER_DEPTH (CUBE_LENGTH+0.01)
#define CUT 0.04
#define CUT_DEPTH (STICKER_DEPTH+0.001)

typedef struct _RubikMove {
        int         face, direction;
        int         position;
} RubikMove;

typedef struct _RubikSlice {
        int         face, rotation;
        int         depth;
} RubikSlice;

typedef struct _RubikGLPart {
	double      angleStepX, angleStepY, angleStepZ, rotateStep;
	int         numTurnInc;
	/*Point       cubeSizex, cubeSizey, cubeSizez;*/
	RubikMove   movement;
	int step;
} RubikGLPart;

typedef struct _RubikGLRec {
	CorePart    core;
	RubikPart   rubik;
	RubikGLPart rubikGL;
} RubikGLRec;

extern Boolean selectPiecesGL(RubikGLWidget w, int x, int y,
	int *face, int *position);
extern void drawFrameGL(RubikGLWidget w, Boolean focus);
extern void drawAllPiecesGL(RubikGLWidget w);
extern void moveAllPiecesGL(RubikGLWidget w, int face, int direction,
	int fast);
extern void movePiecesGL(RubikGLWidget w, int face, int position,
	int direction, Boolean control, int fast);
#ifdef WINVER
extern void resizePuzzleGL(RubikGLWidget w);
extern void exposePuzzleGL(RubikGLWidget w);
#endif

#endif /* _RubikGLP_h */
