/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slabel.h,v 1.5 2004/02/26 06:34:56 justins Exp $ */
/*

   xscorch - slabel.h         Copyright(c) 2000-2003 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/

   Scorch label widget


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, version 2 of the License ONLY.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __slabel_h_included
#define __slabel_h_included


#include <sgtk.h>
#include <gtk/gtk.h>
#include <gtk/gtklabel.h>


/* typecasts */
#define  SC_LABEL(obj)           GTK_CHECK_CAST(obj, sc_label_get_type(), ScLabel)
#define  SC_LABEL_CLASS(klass)   GTK_CHECK_CLASS_CAST(klass, sc_label_get_type(), ScLabelClass)
#define  IS_SC_LABEL(obj)        GTK_CHECK_TYPE(obj, sc_label_get_type())


/* The ScLabel structure */
typedef struct _ScLabel {
   GtkLabel parent;
} ScLabel;


/* ScLabelClass structure */
typedef struct _ScLabelClass {
   GtkLabelClass parent_class;
} ScLabelClass;


/* Label initialisation and execution */
GType sc_label_get_type(void);
GtkWidget *sc_label_new(const char *text);


#endif /* __slabel_h_included */


