'\" t
.\" ** The above line should force tbl to be used as a preprocessor **
.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
juggle \- juggling man screen saver.
.SH SYNOPSIS
.B juggle
.RB [ \-display
.IR host:display.screen ]
.RB [ \-root ]
.RB [ \-window ]
.RB [ \-mono ]
.RB [ \-install | \-noinstall ]
.RB [ \-visual
.IR visual ]
.RB [ \-window\-id
.IR id ]
.RB [ \-pattern
.IR pattern ]
.RB [ \-tail
.IR number ]
.RB [ \-real | \-no\-real ]
.RB [ \-describe | \-no\-describe ]
.RB [ \-balls | \-no\-balls ]
.RB [ \-clubs | \-no\-clubs ]
.RB [ \-torches | \-no\-torches ]
.RB [ \-knives | \-no\-knives ]
.RB [ \-rings | \-no\-rings ]
.RB [ \-bballs | \-no\-bballs ]
.RB [ \-count
.IR count ]
.RB [ \-cycles
.IR cycles ]
.RB [ \-delay
.IR delay ]
.RB [ \-ncolors
.IR ncolors ]
.SH DESCRIPTION
Draws a stick-man juggling various collections of objects.
.SH OPTIONS
.TP
.BI \-display\  host:display.screen
X11 display to use.  Overrides
.B DISPLAY
environment variable.
.TP
.B \-root
Draw on the root window.
.TP
.B \-window
Draw on a newly-created X window.  This is the default.
.TP
.B \-mono
Draw in monochrome.
.TP
.B \-install\  |\  \-noinstall
Turn on/off installing colormap.
.TP
.BI \-visual\  visual
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP
.BI \-window\-id\  id
Draw on an already existing X window.
.TP
.BI \-pattern\ \(dq pattern \(dq
Specify juggling pattern in annotated
.B site-swap
notation.  In 
.B site-swap
notation, the "height" of each throw is given.  E.g., "3" is the height
needed to juggle a 3\-Cascade.  Note that these sequences need to be
chosen carefully, to avoid collisions.

Annotations indicate relative hand movements or tricks:
.TS
cb l.
\&\-	Inside throw (default)
+	Outside throw
\&=	Cross Throw
&	Cross Catch
x	Cross Throw and Catch
\&_	Bounce
.TE
.TP
.BI \-pattern\ \(dq[ pattern ]\(dq
Specify juggling pattern in annotated
.B Adam
notation.  Adam notation is a little harder to visualize.  Each
integer
.B n
represents a cyclic permutation of (0...n).  The equivalent
.B site-swap
value is determined by calculating how many of the permutations it
takes to get back to the identity.  The largest number used is the
same as the number of objects in the pattern.  The advantage of Adam
notation is that these sequences do not need to be chosen carefully,
since all possible sequences are juggle-able.  Annotations are the same
as in
.B site-swap
notation.

For example, both of these describe a 3\-Shower:
.IP
.B \-pattern\ "+5 1"
.IP
.B \-pattern\ "[+3 1]"

For further examples, see the
.B portfolio
list in the source code.
.TP
.BI \-tail\  number
Minimum Trail Length.  0 \- 100.  Default: 0.  Objects may override
this, for example flaming torches always leave a trail.
.TP
.BR \-real\  |\  \-no\-real
Turn on/off real-time juggling.
.B Deprecated.
There should be no need to turn off real-time juggling, even on slow
systems.  Adjust speed using
.B \-count
above.
.TP
.BR \-describe\  |\  \-no\-describe
Turn on/off pattern descriptions.
.TP 
.BR \-balls\  |\  \-no\-balls
Turn on/off Balls.
.TP
.BR \-clubs\  |\  \-no\-clubs
Turn on/off Clubs.
.TP
.BR \-torches\  |\  \-no\-torches
Turn on/off Flaming Torches.
.TP
.BR \-knives\  |\  \-no\-knives
Turn on/off Knives.
.TP
.BR \-rings\  |\  \-no\-rings
Turn on/off Rings.
.TP
.BR \-bballs\  |\  \-no\-bballs
Turn on/off Bowling Balls.
.TP
.BI \-count\  number
Speed. 50 \- 1000.  Default: 200.  This determines the expected time
interval between a throw and the next catch, in milliseconds.
.TP
.BI \-cycles\  number
Performance Length. 50 \- 1000.  Default: 1000.  Setting this smaller
will force the juggler to switch patterns (and objects) more often.
.TP
.BI \-delay\  delay
Additional delay between frames, in microseconds.  Default: 10000.
.B Deprecated.
Adjust speed using
.BR \-count .
.TP
.BI \-ncolors\  ncolors
Maximum number of colors to use.  Default: 32.
.SH ENVIRONMENT
.PP
.TP
.B DISPLAY
to get the default host and display number.
.TP
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 1996,2000,2002,2004 by Tim Auckland.  Permission to
use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided
that the above copyright notice appear in all copies and that both
that copyright notice and this permission notice appear in supporting
documentation.  No representations are made about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.
.SH AUTHOR
Tim Auckland.
