.TH XScreenSaver 1 "30-Aug-05" "X Version 11"
.SH NAME
cube21 - animates the Cube 21 puzzle
.SH SYNOPSIS
.B cube21
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-install]
[\-delay \fImicroseconds\fP]
[\-texture] [\-no\-texture]
[\-mono]
[\-wireframe]
[\-spin] [\-no\-spin]
[\-wander] [\-no\-wander]
[\-randomize] [\-no\-randomize]
[\-spinspeed \fInumber\fP]
[\-rotspeed \fInumber\fP]
[\-wanderspeed \fInumber\fP]
[\-wait \fInumber\fP]
[\-cubesize \fInumber\fP]
[\-colormode \fIarg\fP]
[\-fps]
.SH DESCRIPTION
This program animates a puzzle known as Cube 21 or Square-1.
Its moves are chosen randomly.
.P
Cube 21 is a Rubik-like puzzle invented in 1992.  Its specialities are that
it can change its shape and even the number of possible moves.  It can have
more than 200 different shapes and the total number of configurations
(assuming colors) is several tens of billions.
.SH OPTIONS
.I cube21
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How long to pause between frames.  Default is 20000, or 0.02 second.
.TP 8
.B \-texture
Use texture maps.  This is the default.
.TP 8
.B \-no\-texture
Use solid colors.
.TP 8
.B \-mono
Disable both texture maps and colors.
.TP 8
.B \-wireframe
Only draw outlines.  Outlines of all pieces, not only the whole object, are drawn.
.TP 8
.B \-spin
Spin the whole object around X, Y and Z axes.  This is the default.
.TP 8
.B \-no\-spin
Do not spin, showing the same three faces all the time.
.TP 8
.B \-wander
Move the object around the screen.  This is the default.
.TP 8
.B \-no\-wander
Keep the object centered on the screen.
.TP 8
.B \-randomize
Shuffle the puzzle randomly at startup.  This is the default.
.TP 8
.B \-no\-randomize
Do not shuffle at startup, begin at the shape of cube.
.TP 8
.B \-spinspeed \fInumber\fP
The relative speed of spinning.  Default is 1.0.
.TP 8
.B \-rotspeed \fInumber\fP
The relative speed of the moves.  Default is 3.0.  Setting to \(<= 0.0
makes the object stay at one configuration.
.TP 8
.B \-wanderspeed \fInumber\fP
The relative speed of wandering around the screen.  Default is 1.0.
.TP 8
.B \-wait \fInumber\fP
How long to stay at ending position after each move.  The meaning of
the argument is again relative.  Default is 40.0.
.TP 8
.B \-cubesize \fInumber\fP
Size of the object.  Value of 3.0 fills roughly all the screen (its height).  Default is 0.7.
.TP 8
.B \-colormode \fIargument\fP
How many and which colors should the object have.  The colors are put on the piece
faces so that the puzzle is solvable.  The inner faces are not influenced.
.RS
.TP 8
.BR se " or " silver
Simulate the "Silver Edition" \- white and one random color.
.TP 8
.BR 2 " or " two
Two random colors.
.TP 8
.BR ce " or " classic
Simulate the "Classic Edition" \- white, yellow, orange, red, green and blue.
.TP 8
.BR 6 " or " six
Six random colors.
.TP 8
.BR 1 " or " random " or " rnd
One random color.
.TP 8
Anything else
All faces white.
.RE
.TP 8
.B \-fps
Display a running tally of how many frames per second are being rendered.
In conjunction with \fB\-delay 0\fP, this can be a useful benchmark of 
your GL performance.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2005 by Vaclav Potocek.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Vaclav (Vasek) Potocek <vasek.potocek@post.cz>, 30-Aug-05.
