// file      : xsde/cxx/parser/non-validating/hex-binary.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/non-validating/hex-binary.hxx>

static unsigned char
hex_decode (char c)
{
  unsigned char r = 0xFF;

  if (c >= '0' && c <= '9')
    r = static_cast<unsigned char> (c - '0');
  else if (c >= 'A' && c <= 'F')
    r = static_cast<unsigned char> (10 + (c - 'A'));
  else if (c >= 'a' && c <= 'f')
    r = static_cast<unsigned char> (10 + (c - 'a'));

  return r;
}

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        void hex_binary_pimpl::
        _pre ()
        {
#ifdef XSDE_EXCEPTIONS
          str_.assign ("", 0);
#else
          if (str_.assign ("", 0))
            _sys_error (sys_error::no_memory);
#endif
        }

        void hex_binary_pimpl::
        _characters (const ro_string& s)
        {
          if (str_.size () == 0)
          {
            ro_string tmp (s.data (), s.size ());

            if (trim_left (tmp) != 0)
            {
#ifdef XSDE_EXCEPTIONS
              str_.append (tmp.data (), tmp.size ());
#else
              if (str_.append (tmp.data (), tmp.size ()))
                _sys_error (sys_error::no_memory);
#endif
            }
          }
          else
          {
#ifdef XSDE_EXCEPTIONS
            str_.append (s.data (), s.size ());
#else
            if (str_.append (s.data (), s.size ()))
              _sys_error (sys_error::no_memory);
#endif
          }
        }

        struct buffer_guard
        {
          ~buffer_guard () { delete p_; }
          buffer_guard (buffer* p) : p_ (p) {}

          void
          release () { p_ = 0; }

        private:
          buffer* p_;
        };

        buffer* hex_binary_pimpl::
        post_hex_binary ()
        {
          ro_string tmp (str_);
          ro_string::size_type size = trim_right (tmp);

          size_t n = size / 2;
          buffer* buf = new buffer ();

#ifndef XSDE_EXCEPTIONS
          if (buf == 0)
          {
            _sys_error (sys_error::no_memory);
            return 0;
          }
#endif
          buffer_guard bufg (buf);

#ifdef XSDE_EXCEPTIONS
          buf->size (n);
#else
          if (buf->size (n))
          {
            _sys_error (sys_error::no_memory);
            return 0;
          }
#endif

          if (n != 0)
          {
            const char* src = tmp.data ();
            char* dst = buf->data ();
            size_t i = 0;

            for (; i < n; ++i)
            {
              unsigned char h = hex_decode (src[2 * i]);
              unsigned char l = hex_decode (src[2 * i + 1]);

              if (h == 0xFF || l == 0xFF)
                break;

              dst[i] = (h << 4) | l;
            }
          }

          bufg.release ();
          return buf;
        }
      }
    }
  }
}
