// file      : xsde/cxx/parser/non-validating/parser.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_PARSER_NON_VALIDATING_PARSER_HXX
#define XSDE_CXX_PARSER_NON_VALIDATING_PARSER_HXX

#include <xsde/cxx/config.hxx>
#include <xsde/cxx/string.hxx>
#include <xsde/cxx/ro-string.hxx>

#include <xsde/cxx/parser/elements.hxx>
#include <xsde/cxx/parser/state.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        struct empty_content: virtual parser_base
        {
          // These functions are called when wildcard content
          // is encountered. Use them to handle mixed content
          // models, any/anyAttribute, and anyType/anySimpleType.
          // By default these functions do nothing.
          //
          virtual void
          _start_any_element (const ro_string& ns,
                              const ro_string& name);

          virtual void
          _end_any_element (const ro_string& ns,
                            const ro_string& name);

          virtual void
          _any_attribute (const ro_string& ns,
                          const ro_string& name,
                          const ro_string& value);

          virtual void
          _any_characters (const ro_string&);


          //
          //
          virtual bool
          _start_element_impl (const ro_string&,
                               const ro_string&);

          virtual bool
          _end_element_impl (const ro_string&,
                             const ro_string&);

          virtual bool
          _attribute_impl (const ro_string&,
                           const ro_string&,
                           const ro_string&);

          virtual bool
          _characters_impl (const ro_string&);


          //
          //
          virtual void
          _start_element (const ro_string&,
                          const ro_string&);

          virtual void
          _end_element (const ro_string&,
                        const ro_string&);

          virtual void
          _attribute (const ro_string&,
                      const ro_string&,
                      const ro_string&);

          virtual void
          _characters (const ro_string&);
        };


        //
        //
        struct simple_content: virtual empty_content
        {
          //
          //
          virtual void
          _attribute (const ro_string& ns,
                      const ro_string& name,
                      const ro_string& value);

          virtual void
          _characters (const ro_string&);
        };


        //
        //
        struct complex_content: virtual empty_content
        {
          //
          //
          virtual void
          _start_element (const ro_string& ns,
                          const ro_string& name);

          virtual void
          _end_element (const ro_string& ns,
                        const ro_string& name);

          virtual void
          _attribute (const ro_string& ns,
                      const ro_string& name,
                      const ro_string& value);

          virtual void
          _characters (const ro_string&);


          //
          //
          virtual void
          _pre_impl ();

          virtual void
          _post_impl ();

        protected:
          parse_stack context_;
        };

        // Base for xsd:list.
        //
        struct list_base: virtual simple_content
        {
          virtual void
          _xsde_parse_item (const ro_string&) = 0;

          virtual void
          _pre ();

          virtual void
          _characters (const ro_string&);

          virtual void
          _post ();

        protected:
          string buf_;
        };
      }
    }
  }
}

#endif  // XSDE_CXX_PARSER_NON_VALIDATING_PARSER_HXX
