// file      : xsde/cxx/serializer/elements.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <cxx/serializer/elements.hxx>

namespace CXX
{
  namespace Serializer
  {
    // Keep this symbol first to help HP-UX linker (long symbols?).
    //
    Content::Value Context::
    content (SemanticGraph::Complex& c)
    {
      using namespace SemanticGraph;

      if (c.mixed ())
        return Content::mixed;

      if (c.inherits_p ())
      {
        Type& base (c.inherits ().base ());

        if (Complex* cb = dynamic_cast<Complex*> (&base))
          return content (*cb);

        if (base.is_a<AnyType> ())
          return Content::complex;

        // Everyhting else (built-in type and AnySimpleType) is simple
        // content.
        //
        return Content::simple;
      }
      else
        return Content::complex;
    }

    Context::
    Context (std::wostream& o,
             SemanticGraph::Schema& root,
             CLI::Options const& ops)
        : CXX::Context (o,
                        root,
                        "char",
                        ops.value<CLI::include_with_brackets> (),
                        ops.value<CLI::include_prefix> (),
                        "", // export symbol
                        ops.value<CLI::namespace_map> (),
                        ops.value<CLI::namespace_regex> (),
                        ops.value<CLI::namespace_regex_trace> (),
                        ops.value<CLI::include_regex> (),
                        ops.value<CLI::include_regex_trace> (),
                        ops.value<CLI::generate_inline> ()),
          options (options_),
          xml_serializer (xml_serializer_),
          simple_base (simple_base_),
          complex_base (complex_base_),
          validation (validation_),
          exceptions (exceptions_),
          stl (stl_),
          options_ (ops),
          xml_serializer_ ("genx"),
          validation_ (!ops.value<CLI::suppress_validation> ()),
          exceptions_ (!ops.value<CLI::no_exceptions> ()),
          stl_ (!ops.value<CLI::no_stl> ())
    {
      string_type = L"::xsde::cxx::ro_string";

      simple_base_ = L"::xsde::cxx::serializer::";
      simple_base_ += (validation ? L"validating" : L"non_validating");
      simple_base_ += L"::simple_content";

      complex_base_ = L"::xsde::cxx::serializer::";
      complex_base_ += (validation ? L"validating" : L"non_validating");
      complex_base_ += L"::complex_content";
    }


    String const& Context::
    ret_type (SemanticGraph::Type& t)
    {
      return t.context ().get<String> ("ret-type");
    }

    String const& Context::
    arg_type (SemanticGraph::Type& t)
    {
      return t.context ().get<String> ("arg-type");
    }

    //
    //
    String const& Context::
    epresent (SemanticGraph::Particle& p)
    {
      return p.context ().get<String> ("present");
    }

    String const& Context::
    epresent (SemanticGraph::Attribute& a)
    {
      return a.context ().get<String> ("present");
    }

    String const& Context::
    enext (SemanticGraph::Particle& p)
    {
      return p.context ().get<String> ("next");
    }

    String const& Context::
    enext (SemanticGraph::AnyAttribute& a)
    {
      return a.context ().get<String> ("next");
    }

    String const& Context::
    etag (SemanticGraph::Particle& p)
    {
      return p.context ().get<String> ("tag");
    }

    String const& Context::
    earm (SemanticGraph::Choice& c)
    {
      return c.context ().get<String> ("arm");
    }

    String const& Context::
    earm_tag (SemanticGraph::Choice& c)
    {
      return c.context ().get<String> ("arm-tag");
    }

    //
    //
    String const& Context::
    eserializer (SemanticGraph::Member& m)
    {
      return m.context ().get<String> ("serializer");
    }

    String const& Context::
    emember (SemanticGraph::Member& m)
    {
      return m.context ().get<String> ("member");
    }

    //
    //
    String const& Context::
    eserialize (SemanticGraph::Any& a)
    {
      return a.context ().get<String> ("serialize");
    }

    String const& Context::
    eserialize (SemanticGraph::AnyAttribute& a)
    {
      return a.context ().get<String> ("serialize");
    }

    //
    //
    String const& Context::
    eimpl (SemanticGraph::Type& t)
    {
      return t.context ().get<String> ("impl");
    }
  }
}
