/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONFIGC_H
#define CONFIGC_H

class ConfigC
{
 public:
    static const int version;
    
    static const char* const groups[];
    static const char* const keys[];
    
    enum groupID
    {
        Audio = 0, Emulation, Mixer, Misc, MainWindow,
        Playlist, PlaylistEditor, HVSC_STIL, Selector
    };

    enum keyID
    {
        Frequency = 0, Channels, BitsPerSample, SampleEncoding,
        MaxFrags, FragSize, BufSize,
        ForceSongSpeed, ClockSpeed, MemoryMode, MOS8580,
        MeasuredMasterVolume, UseFilter, FilterFs, FilterFm, FilterFt,
        MixerType, AutoPanning, Voice1Vol, Voice2Vol, Voice3Vol, Voice4Vol, 
        PanPosLeftHQ, PanPosRightHQ, PanPosLeftFP, PanPosRightFP,
        HVSC_Root, STIL_ShowGlobal, STIL_ShowEntries, HVSC_BugEntries,
        STIL_AllOrSong, STIL_AutoResize, STIL_MaxHeight, STIL_Viewer,
        SongLenDB, PlaytimeDefault, FadeOutDefault, 
        Dir, SaveDir, NameFilter, Open,
        ConfigVersion, Usage, ExpertMode, X, Y, W, H
    };
};

#endif  /* CONFIGC_H */
