/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <sidplay/sidtune.h>

#include <qevent.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#include "GlobalIcon.h"
#include "HistoryDialog.h"

HistoryDialog::HistoryDialog(QWidget* parent, const char* name)
: HistoryDialogData(parent,name), file(0)
{
    setIcon(*mainIcon);
    setMinimumSize(width(),140);
 
    list.setAutoDelete(true);
    list.clear();
    maxItems = 200;
    
    QString tmp;
    tmp.sprintf("%d",maxItems);
    sizeLineEdit->setText(tmp);
}

HistoryDialog::~HistoryDialog()
{
    if ( file!= 0)
        delete file;
}

bool HistoryDialog::load(const char* fileName)
{
    if ( file!=0 )
        delete file;
    file = new HistoryFile(fileName);
    return file->load(*this);
}

bool HistoryDialog::save()
{
    if ( file!=0 )
        return file->save(*this);
    else
        return false;
}

void HistoryDialog::add(const char* fileName, const char* info)
{
    if (list.count() >= maxItems)
    {
        list.removeFirst();
        historyListBox->removeItem(0);
    }
    list.append(new HistoryItem(fileName,info));
    historyListBox->insertItem(info);
}

void HistoryDialog::historyItemHighlighted(int index)
{
    emit playHistoryItem(list.at(index)->fileName());
}

void HistoryDialog::prevButtonClicked()
{
    if (historyListBox->count() > 0)
    {
        int index = historyListBox->currentItem();
        index--;
        if (index >= 0)  // first is 0
            historyListBox->setCurrentItem(index);
    }
}

void HistoryDialog::nextButtonClicked()
{
    int count = historyListBox->count();
    if (count > 0)
    {
        int index = historyListBox->currentItem();
        index++;
        if (index <= (count-1))  // last is count-1 
            historyListBox->setCurrentItem(index);
    }
}

void HistoryDialog::deleteButtonClicked()
{
    int index = historyListBox->currentItem();
    if (index >= 0)
    {
        list.remove(index);
        historyListBox->removeItem(index);
    }
}

void HistoryDialog::clearButtonClicked()
{
    if ( !list.isEmpty() )
    {
        QMessageBox mb( "SIDPLAY",
                       "Do you really want to clear the history?",
                       QMessageBox::Information,
                       QMessageBox::Yes,
                       QMessageBox::No | QMessageBox::Default | QMessageBox::Escape,
                       0);
        mb.setButtonText( QMessageBox::Yes, "Yes" );
        mb.setButtonText( QMessageBox::No, "No" );
        switch( mb.exec() ) 
        {
         case QMessageBox::Yes:
            {
                historyListBox->clear();
                list.clear();
                break;
            }
         case QMessageBox::No:
            break;
        }
    }
}

void HistoryDialog::historySizeChanged()
{
    maxItems = sizeLineEdit->text().toInt();
    while (list.count() > maxItems)
    {
        list.removeFirst();
        historyListBox->removeItem(0);
    }
}

void HistoryDialog::resizeEvent(QResizeEvent*)
{
    int w = width();
    int h = height();
    
    historyListBox->setGeometry(0,0,w-0,h-84);
    deleteButton->move(150,h-70);
    clearButton->move(220,h-70);
    prevButton->move(40,h-40);
    nextButton->move(160,h-40);
    maxItemsLabel->move(10,h-70);
    sizeLineEdit->move(90,h-70);
}
