/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

// --------------------------------------------------------------------------
// HISTORY FILE EVALUATION
// --------------------------------------------------------------------------

#ifdef SID_WB_DEBUG
#include <iomanip.h>
#include <iostream.h>
#endif
#include <fstream.h>
#include <stdlib.h>
#include <unistd.h>

#include "HistoryFile.h"

// Keywords.
const char HistoryFile::key_Version[] = "Version";
const char HistoryFile::key_MaxItems[] = "MaxItems";

HistoryFile::HistoryFile(const char* inFileName)
: TextFile(), fileName(inFileName), version(1)
{
}

// -------------------------------------------------------------------- Input

bool HistoryFile::load(HistoryDialog& dialog)
{
    open(fileName);
    
    int inVersion = version;
    
    while (status && isGood && !isEOF())  // line-by-line loop
    {
        getLine();
        // Skip blank and comment lines.
        while (status && !isEOF() && isBlank() || isComment())
        {
            getLine();
        };
        if ( isEOF() )
            break;
        // Evaluate line.
#ifdef XSID_WB_DEBUG
        cout << "Line " << getLineNum() << ", " << getLineLen() << ": ";
        cout << getLineBuf() << endl;
        cout << "ParseBuf: " << getParseBuf() << endl;
#endif

        if (isKey(key_Version))
            inVersion = atoi(getCurParseBuf());
        else if (isKey(key_MaxItems))
            dialog.maxItems = atoi(getCurParseBuf());
        
        else
        {
            QString tmpFile = getLineBuf();
            getLine();
            QString tmpTitle = getLineBuf();
            dialog.add(tmpFile,tmpTitle);
#ifdef XSID_WB_DEBUG
            cout << tmpFile << endl;
            cout << tmpTitle << endl;
#endif
        }
        
    };
    
    close();
    return isGood;
}

// ------------------------------------------------------------------- Output

bool HistoryFile::save(HistoryDialog& dialog)
{
    bool wasSuccess = false;

#ifdef XSID_HAVE_IOS_BIN
    ofstream toFile(fileName,ios::out|ios::bin|ios::trunc);
#else
    ofstream toFile(fileName,ios::out|ios::binary|ios::trunc);
#endif
    if ( !toFile.fail() )
    {
        toFile 
            << "# SIDPLAY/X11 history file." << endl
            << "#" << endl
            << "# DO NOT edit." << endl
            << endl;

        toFile << key_Version << '=' << version << endl;
        toFile << key_MaxItems << '=' << dialog.maxItems << endl;
        
        for (unsigned int n=0; n<dialog.list.count(); n++)
        {
            toFile << dialog.list.at(n)->fileName() << endl;
            toFile << dialog.list.at(n)->title() << endl;
        }
             
        toFile.close();
        wasSuccess = !toFile.fail();
    }
    
    return wasSuccess;
}
