/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FADING_H
#define FADING_H

#include <sidplay/mytypes.h>

#include "AudioConfig.h"

class FadingBase
{
 public:
	FadingBase();

	virtual void set(const AudioConfig&, const int msecs) = 0;
	virtual void fade(ubyte* buffer, const udword bufLen) = 0;

	const int fadeLevel;
	int currentLevel;

	int millisecs;
	
	udword step, count;
};

class FadingIn : public FadingBase
{
 public:
	FadingIn();
	
	void set(const AudioConfig&, const int msecs = 0);
	void fade(ubyte* buffer, const udword bufLen);

 private:
	void fadeIn8(ubyte*, const udword);
	void fadeIn16(ubyte*, const udword);
	void dummy(ubyte*, const udword);
	void (FadingIn::*proc)(ubyte*, const udword);
};

class FadingOut : public FadingBase
{
 public:
	FadingOut();
	
	void set(const AudioConfig&, const int msecs = 0);
	void fade(ubyte* buffer, const udword bufLen);
	
 private:
	void fadeOut8(ubyte*, const udword);
	void fadeOut16(ubyte*, const udword);
	void dummy(ubyte*, const udword);
	void (FadingOut::*proc)(ubyte*, const udword);
};

#endif  /* FADING_H */
