/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sidplay/myendian.h>

#include "SidTuneMod.h"
#include "MD5.h"

const char sidtune_text_songNumberExceed[] = "WARNING: Selected song number was too high";
const char sidtune_text_PAL_VBI[] = "50 Hz VBI (PAL)";
const char sidtune_text_PAL_CIA[] = "CIA 1 Timer A (PAL)";
const char sidtune_text_NTSC_VBI[] = "60 Hz VBI (NTSC)";
const char sidtune_text_NTSC_CIA[] = "CIA 1 Timer A (NTSC)";

void SidTuneMod::createMD5(MD5& myMD5)
{
    if (isCached && status)
    {
        // Include C64 data.
        myMD5.append(cachePtr+fileOffset,info.c64dataLen);
        ubyte tmp[2];
        // Include INIT and PLAY address.
        writeLEword(tmp,info.initAddr);
        myMD5.append(tmp,sizeof(tmp));
        writeLEword(tmp,info.playAddr);
        myMD5.append(tmp,sizeof(tmp));
        // Include number of songs.
        writeLEword(tmp,info.songs);
        myMD5.append(tmp,sizeof(tmp));
        // Include song speed for each song.
        for (uword s = 1; s <= info.songs; s++)
        {
            selectSongPublic(s);
            myMD5.append(&info.songSpeed,sizeof(info.songSpeed));
        }
    }
}

// Bypass the wrong member protection in libsidplay1.

// First check, whether a song is valid. Then copy any song-specific
// variable information such a speed/clock setting to the info structure.
//
// This is a private member function. It is used only by player.cpp.
uword SidTuneMod::selectSongPublic(uword selectedSong)
{
    // Determine and set starting song number.
    if (selectedSong == 0)
    {
        selectedSong = info.startSong;
    }
    else if ((selectedSong > info.songs) || (selectedSong > classMaxSongs))
    {
        info.statusString = sidtune_text_songNumberExceed;
        selectedSong = info.startSong;
    }
    info.lengthInSeconds = songLength[selectedSong-1];
    // Retrieve song speed definition.
    info.songSpeed = songSpeed[selectedSong-1];
    info.clockSpeed = clockSpeed[selectedSong-1];
    // Assign song speed description string depending on clock speed.
    if (info.clockSpeed == SIDTUNE_CLOCK_PAL)
    {
        if (info.songSpeed == SIDTUNE_SPEED_VBI)
        {
            info.speedString = sidtune_text_PAL_VBI;
        }
        else
        {
            info.speedString = sidtune_text_PAL_CIA;
        }
    }
    else  //if (info.clockSpeed == SIDTUNE_CLOCK_NTSC)
    {
        if (info.songSpeed == SIDTUNE_SPEED_VBI)
        {
            info.speedString = sidtune_text_NTSC_VBI;
        }
        else
        {
            info.speedString = sidtune_text_NTSC_CIA;
        }
    }
    return (info.currentSong=selectedSong);
}

