/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "TimeLCD.h"

static const int timeDigitMax[] =
{
    // 60 sec, 60 min
    // '9'++, '6', '9'++, '6'
    0x3a, 0x36, 0x3a, 0x36, -1
};

static const int timeDigitIndex[] =
{
    // Order in which to increase the digits;
    4, 3, 1, 0, -1
};

TimeLCD::TimeLCD(QWidget* parent, const char* name) : QLCDNumber(parent,name)
{
    init();
}

void TimeLCD::init()
{
    timeInSecs = 0;
    timeString[0] = ' ';
    timeString[1] = '0';
    timeString[2] = ':';
    timeString[3] = '0';
    timeString[4] = '0';
    timeString[5] = 0;
}

void TimeLCD::resetDisplay()
{
    init();
    display(timeString);
}

void TimeLCD::updateDisplay(const int secs)
{
    if (timeInSecs != secs)
    {
        while (timeInSecs < secs)
        {
            timeInSecs++;
            int i = 0;
            while (timeDigitIndex[i] != (-1))
            {
                int d = timeDigitIndex[i];  // get digit number
                if (timeString[d] == ' ')   // digit not used so far
                    timeString[d] = '1';
                else
                    timeString[d]++;        // increase digit
                if (timeString[d] == timeDigitMax[i])
                {
                    timeString[d] = '0';
                    i++;  // proceed to next digit only if necessary
                }
                else
                    break;
            };
        };
        display(timeString);
        // While this looks good in Qt 1.4x, the clock flickers in
        // Qt 2.0. The widget's internalSetString() function does
        // a repaint() which erases the widget prior to repainting.
        // Maybe this is the cause of the flickering?
        // Gone as of Qt 2.2.0. -- ms
    }
}
