/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include <stdio.h>

#include <qfiledialog.h>
#include <qstring.h>
#include <qevent.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qtable.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qmessagebox.h>
#include <qpushbutton.h>

#ifdef XSID_HAVE_TSID2
#include <tsid2/struct.h>
#endif

#include "GlobalIcon.h"
#include "TSID2Dialog.h"

TSID2Dialog::TSID2Dialog(QWidget* parent, const char* name)
: TSID2DialogData(parent,name)
{
    setIcon(*mainIcon);

}

TSID2Dialog::~TSID2Dialog()
{
}

void TSID2Dialog::setConfig(const TSID2Config& inConfig)
{
    config = inConfig;
    backupConfig = inConfig;
    setButtons();
}

const TSID2Config& TSID2Dialog::getConfig() const
{
    return config;
}

#ifdef XSID_HAVE_TSID2
void TSID2Dialog::update(TBLIST* list)
{
    unsigned int i;
    const tblistRecord* rec;
    char* tmp;
    
    tblist=list;

    unsigned int sizeT=list->hotlistTSize();
    unsigned int sizeN=list->hotlistNSize();

    TSID2TTable->setNumRows(sizeT);
    TSID2NTable->setNumRows(sizeN);

    for (i=1; i<=sizeT; i++) {
      rec=list->hotlistTInfo(i);
      tmp=new char[strlen(rec->name)+16];
      sprintf(tmp, "%s  #%i", rec->name, rec->tune);
      TSID2TTable->setText((int)(i-1), 0, tmp);
      sprintf(tmp, "%i", rec->second);
      TSID2TTable->setText((int)(i-1), 1, tmp);
      delete[] tmp;
    }

    for (i=1; i<=sizeN; i++) {
      rec=list->hotlistNInfo(i);
      tmp=new char[strlen(rec->name)+16];
      sprintf(tmp, "%s  #%i", rec->name, rec->tune);
      TSID2NTable->setText((int)(i-1), 0, tmp);
      sprintf(tmp, "%i", rec->number);
      TSID2NTable->setText((int)(i-1), 1, tmp);
      delete[] tmp;
    }

    // insert label with info
    TextLabelTTime->setNum((int)list->getTotalTime());
    TextLabelNListen->setNum((int)list->getTotalNumber());
}
#endif

void TSID2Dialog::okButtonClicked()
{
    hide();
#ifdef XSID_HAVE_TSID2
    config.absBasePath.setPath(tsid2Directory->text());
    int stime=(atoi)(sizeTLineEdit->text());
    if (stime>0) config.number_t=(unsigned int)stime;
    int snum=(atoi)(sizeNLineEdit->text());
    if (snum>0) config.number_n=(unsigned int)snum;

    tblist->setSize(config.number_t, config.number_n);
    if (RadioButtonD->isChecked()) config.engine=TBLIST::DINAMIC;
    else config.engine=TBLIST::STATIC;
    config.custom=(CheckBoxPath->isChecked()==true);
    backupConfig = config;
    setButtons();
#endif
}

void TSID2Dialog::cancelButtonClicked()
{
    hide();
    config = backupConfig;
    setButtons();
}

void TSID2Dialog::browseButtonClicked()
{
    QString dirName =
        QFileDialog::getExistingDirectory(tsid2Directory->text(),this,0,
                                          "Select TSID2 root directory");
    if ( !dirName.isEmpty() )
        tsid2Directory->setText(dirName);
}

void TSID2Dialog::rebuildButtonClicked()
{
    hide();
#ifdef XSID_HAVE_TSID2
    tblist->rebuildLists();
#endif
}

void TSID2Dialog::CheckBoxPath_stateChanged( int )
{
    if (CheckBoxPath->isChecked()) {
      tsid2Directory->setEnabled(true);
    } else {
        tsid2Directory->setEnabled(false);
      }
}

void TSID2Dialog::setButtons()
{
#ifdef XSID_HAVE_TSID2
    QString *tmp;
    tsid2Directory->setText(config.absBasePath.path());

    tmp=new QString();
    tmp->setNum((int)config.number_t);
    sizeTLineEdit->setText(tmp->latin1());
    delete tmp;

    tmp=new QString();
    tmp->setNum((int)config.number_n);
    sizeNLineEdit->setText(tmp->latin1());
    delete tmp;

    RadioButtonD->setChecked(config.engine==TBLIST::DINAMIC);
    RadioButtonS->setChecked(config.engine==TBLIST::STATIC);

    CheckBoxPath->setChecked(config.custom==1);
    if (config.custom==1) {
      tsid2Directory->setEnabled(true);
    } else {
        tsid2Directory->setEnabled(false);
      }
#endif
}
