/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "AudioDrivers.h"
#include "AudioBase.h"

#ifdef XSID_WB_DEBUG
#include <iostream>
#include <iomanip>
using namespace std;
#endif

AudioDrivers::List AudioDrivers::driverList;

AudioDrivers::Entry AudioDrivers::theDriver;

AudioDrivers::AudioDrivers()
{
}

AudioDrivers::~AudioDrivers()
{ 
  dispose();
}

// dispose memory used
void AudioDrivers::dispose() {
  while ( !driverList.empty() )
    {
        delete driverList.back().pDriver;
#ifdef XSID_WB_DEBUG
        cout << "ADR::~ deleting: " << driverList.back().name << endl;
#endif
        driverList.pop_back();
    }
}

void AudioDrivers::setDriver( const QString& name )
{
    AudioDrivers::List::iterator it;
    for ( it = AudioDrivers::begin(); it != AudioDrivers::end(); it++ )
    {
        if ( it->name == name )
        {
            theDriver = *it;
#ifdef XSID_WB_DEBUG
            cout << "ADR::setDriver: " << theDriver.name << endl;
#endif
        }
    }
}

AudioBase* AudioDrivers::getDriver()
{
    return theDriver.pDriver;
}

const QString& AudioDrivers::getName()
{
    return theDriver.name;
}

void AudioDrivers::addDriver( AudioBase* p, bool isDefault )
{
    Entry e;
    e.pDriver = p;
    e.name = p->getName();
    driverList.push_back( e );
#ifdef XSID_WB_DEBUG
    cout << "ADR::addDriver: " << e.name << endl;
#endif
    if ( isDefault )
        theDriver = e;
}

AudioDrivers::List::iterator AudioDrivers::begin()
{
    return driverList.begin();
}

AudioDrivers::List::iterator AudioDrivers::end()
{
    return driverList.end();
}
