/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ConfigC.h"

const int ConfigC::version = 1;

const char* const ConfigC::groups[] =
{ 
    "Audio", "Emulation", "Mixer", "Misc", "Main Window",
    "Playlist", "Playlist Editor", "HVSC / STIL", "Selector", "SidId"
#ifdef XSID_HAVE_TSID2
    , "TSID2"
#endif
};

const char* const ConfigC::keys[] =
{ 
    // Audio
    "Frequency", "Channels", "BitsPerSample", "SampleEncoding",
    "MaxFrags", "FragSize", "BufSize", "Driver",
    // Emulation
    "ForceSongSpeed", "ForceSidModel", "ClockSpeed", "MemoryMode", "MOS8580",
    "MeasuredMasterVolume", "UseFilter", "FilterFs", "FilterFm", "FilterFt",
    // Mixer
    "Mixer", "AutoPanning", "Voice1Vol", "Voice2Vol", "Voice3Vol", "Voice4Vol",
    "PanPosLeftHQ", "PanPosRightHQ", "PanPosLeftFP", "PanPosRightFP",
    // HVSC / STIL
    "HVSC_Root", "STIL_ShowGlobal", "STIL_ShowEntries", "HVSC_BugEntries", "STIL_AllOrSong",
    "STIL_AutoResize", "STIL_MaxHeight", "STIL_Viewer",
    // Playlist
    "SongLenDB",
    // Playlist Editor
    "PlaytimeDefault", "FadeOutDefault",
    // Selector
    "Directory", "SaveDir", "NameFilter", "Open",
    // SidId
    "SidIdFile",
    // Misc
    "ConfigVersion", "Usage", "ExpertMode",
    "X", "Y", "W", "H"
#ifdef XSID_HAVE_TSID2
    //tsid2
    ,"BasePath", "Custom", "Number_N", "Number_T", "Engine"
#endif
};

