/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef HVSC_DIALOG_H
#define HVSC_DIALOG_H

#include "HVSC_DialogData.h"
#include "HVSC_Config.h"

class HVSC_Dialog : public HVSC_DialogData
{
    Q_OBJECT

public:

    HVSC_Dialog(QWidget* parent = 0, const char* name = 0);

    void setConfig(const HVSC_Config&);
    const HVSC_Config& getConfig() const;

 protected:
    
    HVSC_Config config;
    HVSC_Config backupConfig;

    void setButtons();

 protected slots:

    void okButtonClicked();
    void cancelButtonClicked();
    void browseButtonClicked();

 signals:

    void changed(const HVSC_Config&);

};

#endif  /* HVSC_DIALOG_H */
