#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>

#define MAXPICT 250
#define C_LV 32

extern int SetPopularXColor(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV]);
extern void near_color(XColor *wcol, int Cgtb[C_LV][C_LV][C_LV]);

main(int argc, char *argv[])
{
    Display *disp;
    Window root, wind;
    Pixmap pixmap;
    Pixmap pix[MAXPICT/8];
    char aaa[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    XpmAttributes A[MAXPICT], B;
    XImage *ximage[MAXPICT], *simage;
    Colormap wcolmap;
    XColor wcol[256];
    XColor *xcol[MAXPICT];
    GC gc;
    XSizeHints hints;
    int Cgtb[C_LV][C_LV][C_LV];
    int *sortc, count = 0;
    int i,j,k,l,m,n,s,t,u;
    int flags = DoRed | DoGreen | DoBlue;
    int KOSUU = 3;
    unsigned char change[256];

    KOSUU = argc -1;
    disp = XOpenDisplay(NULL);
    root = RootWindow(disp, 0);
    if(argc > MAXPICT){
	fprintf(stdout,"Too mamy picture\n");
	exit(0);
    }
    wind = XCreateSimpleWindow(disp,root,0,0,
			       1000,800,0,0,0);
    pixmap = XCreatePixmap(disp, wind, 1000, 800, 8);

    XStoreName(disp, wind, "Fix2"); 
    hints.flags = USPosition;
    XSetWMNormalHints(disp, wind, &hints);
    wcolmap = XCreateColormap(disp, wind,
			     DefaultVisual(disp,DefaultScreen(disp)),
			     AllocAll);
    gc = XCreateGC(disp, wind, 0, 0);

    for(l=0; l<C_LV; l++)for(m=0; m<C_LV; m++)for(n=0; n<C_LV; n++)
	Cgtb[l][m][n] = 0;

    for(i=0; i<argc-1; i++)
    {
	A[i].colormap = XCreateColormap(disp, wind,
			DefaultVisual(disp,DefaultScreen(disp)),
			AllocNone);
	A[i].depth = DefaultDepth(disp, 0);
	A[i].valuemask = XpmColormap | XpmReturnPixels;
	XpmReadFileToImage(disp,argv[i+1],&ximage[i],&simage,&A[i]);
	XFree((char *)simage);

	xcol[i] = (XColor *)malloc(sizeof(XColor)*A[i].npixels);
	for(j=0; j<A[i].npixels; j++) xcol[i][j].pixel = j;
	XQueryColors(disp,A[i].colormap,xcol[i],A[i].npixels);
	l = A[i].width * A[i].height;
	for(j=0; j<l; j++)
	{
	    m = (unsigned char)((ximage[i]->data)[j]);
	    Cgtb[xcol[i][m].red>>11][xcol[i][m].green>>11][xcol[i][m].blue>>11]++;
	}    
    }

    k = SetPopularXColor(wcol, Cgtb);
    near_color(wcol, Cgtb);
    XStoreColors(disp,wcolmap,wcol,k);

    for(i=0; i<argc-1; i++)
    {
	for(j=0; j<A[i].npixels; j++)
	{
	    l = xcol[i][j].red   >> 11;
	    m = xcol[i][j].green >> 11;
	    n = xcol[i][j].blue  >> 11;
	    change[xcol[i][j].pixel] = -Cgtb[l][m][n]-1;
	}
	t = A[i].width*A[i].height;
	for(s=0; s<t; s++)
	    (ximage[i]->data)[s] 
		= change[(unsigned char)((ximage[i]->data)[s])];
    }

    XMapWindow(disp, wind);
    XSetWindowColormap(disp,wind,wcolmap);
    XFlush(disp);
    sleep(1);
    m = n = 0;
    for(i=0; i<argc-1; i++)
    {
	XPutImage(disp,wind,gc,ximage[i],0,0,m,n,A[i].width,A[i].height);
	n += A[i].height;
	if((n / A[i].height) == 8){n=0; m+=A[i].width;}
    }
    XCopyArea(disp, wind, pixmap, gc, 0, 0, 1000, 800, 0, 0);
    getchar();
    B.valuemask = XpmColormap;
    B.colormap = wcolmap;
    B.width = 1000;
    B.height = 800;
    m = 0;
    for(i=0; i<(argc-1)/KOSUU; i++)
    {
	pix[i] = XCreatePixmap(disp, wind, A[i*KOSUU].width, A[i*KOSUU].height*KOSUU, 8);
	XCopyArea(disp, pixmap, pix[i], gc, m, 0,
		  A[i*KOSUU].width, A[i*KOSUU].height*KOSUU, 0, 0);
	B.width = A[i*KOSUU].width;
	B.height = A[i*KOSUU].height*KOSUU;
	B.x_hotspot = 0;
	B.y_hotspot = 0;
	XpmWriteFileFromPixmap(disp, aaa+i, pix[i], NULL, &B);
	fprintf(stdout,"%d,%d,%d,%d\n",A[i*KOSUU].width,A[i*KOSUU].height,i,m);
	m += A[i*KOSUU].width;
    }
    XFlush(disp);
    XCloseDisplay(disp);
}

void printImage(XImage *image)
{
    int i;

    fprintf(stderr,"width            = %d\n",image->width);
    fprintf(stderr,"height           = %d\n",image->height);
    fprintf(stderr,"xoffset          = %d\n",image->xoffset);
    fprintf(stderr,"format           = %d\n",image->format);
    fprintf(stderr,"byte_order       = %d\n",image->byte_order);
    fprintf(stderr,"bitmap_unit      = %d\n",image->bitmap_unit);
    fprintf(stderr,"bitmap_bit_order = %d\n",image->bitmap_bit_order);
    fprintf(stderr,"bitmap_pad       = %d\n",image->bitmap_pad);
    fprintf(stderr,"depth            = %d\n",image->depth);
    fprintf(stderr,"bytes_per_line   = %d\n",image->bytes_per_line);
    fprintf(stderr,"bits_per_pixel   = %d\n",image->bits_per_pixel);
    fprintf(stderr,"red_mask         = %ld\n",image->red_mask);
    fprintf(stderr,"green_mask       = %ld\n",image->green_mask);
    fprintf(stderr,"blue_mask        = %ld\n",image->blue_mask);

    for(i = 0; i<256; i++)
	fprintf(stderr,"%3d:",(unsigned char)(image->data)[i]);
}
