/*
 *  Xtend is Copyright (C) 1998-1999 David M. Shaw <dshaw@jabberwocky.com>
 * 
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 * 
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 * 
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <errno.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "x10.h"
#include "exec.h"
#include "util.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_VFORK_H
#include <vfork.h>
#endif

extern int errno;
extern char **environ;
extern char *shell;
extern char *commands[];
extern int verbose, statusfile;
extern unsigned char addresstable[16][16];
extern char *commandtable[NUM_COMMANDS][16][16];

static char RCSID[] = "@(#) $Id: exec.c,v 2.8.2.8 1999/02/11 05:33:51 dshaw Exp $";

void
docommands (int house, x10code command)
{
  int x = (int) RCSID;		/* stupid hack */
  int dimlevel=house,inc=16;

  if (verbose > 3)
    if(command==PREDIM1)
      printf("Doing commands for Pre-set Dim, level %d :\n",house+1);
    else
      printf ("Doing commands for house %c, command %s :\n", house + 65, commands[command]);

  /* This is weird, but probably accurate to the X10 hardware.  Since
     a pre-set dim can't have a house code on it, we must check them
     all. */

  if(command==PREDIM1)
    {
      inc=1;
      house=0;
    }

  for ( ; house < 16; house+=inc)
    for (x = 0; x < 16; x++)
      {
	if (verbose > 8)
	  printf ("Unit %c%d is currently %s (%d)\n", house + 65, x + 1,
		  (addresstable[house][x] & ONOFFBIT) ? "on" : "off",
		  addresstable[house][x]);

	/*
	  Here's the rules:
	  If it's a bright command, and we're off and a light, turn on.
	  If it's a dim command and we're off and a light, turn on.
	  If it's a lights-on command, and we're a light, turn on.
	  If it's an all-off command, turn off.
	  Everything else is obvious.
	*/

	if ((addresstable[house][x] & ADDRESSBIT) ||
	    command == ALLOFF || command == LIGHTSON ||
	    command==LIGHTSOFF)
	  {
	    switch (command)
	      {
	      case LIGHTSOFF:
		/* if it's an appliance, don't bother */
		if (addresstable[house][x] & APPLBIT)
		  break;
	      case ALLOFF:
	      case OFF:
		addresstable[house][x] &= ~ONOFFBIT;
		break;
	      case LIGHTSON:
		/* if it's an appliance, don't bother */
		if (addresstable[house][x] & APPLBIT)
		  break;
	      case ON:
		addresstable[house][x] |= ONOFFBIT;
		break;
	      case DIM:
	      case BRIGHT:
	      case PREDIM1:
		if ((addresstable[house][x] & APPLBIT) == 0 &&
		    (addresstable[house][x] & ONOFFBIT) == 0)
		  addresstable[house][x] |= ONOFFBIT;
		break;
	      case STATUSON:
	      case STATUSOFF:
	      case STATUSREQUEST:
	      case HAILREQ:
	      case HAILACK:
		break;
	      default:
		return;
	      }
	    
	    if (statusfile != -1)
	      updatestatusfile (house, x);
	  }
	
	/* set up the environment of what our current status is */
	changeenv (house, x);
	
	if (verbose > 8)
	  printf ("Unit %c%d is now %s (%d)\n", house + 65, x + 1,
		  (addresstable[house][x] & ONOFFBIT) ? "on" : "off",
		  addresstable[house][x]);
      }
  
  /* for some reason in X10, all-off does this. */
  if (command == ALLOFF)
    wipeaddresstable (house);

  if(command==PREDIM1)
    house=0;
  else
    house-=16; /* put the house back to where it should be */

/* statusrequest in thing above?  lights off */

  for ( ; house < 16; house+=inc)
    for (x = 0; x < 16; x++)
      {
	if ((commandtable[command][house][x] != NULL &&
	     (addresstable[house][x] & ADDRESSBIT ||
	      command == ALLOFF || command == LIGHTSON
	      || command == STATUSREQUEST)))
	  {
	    if (verbose > 1)
	      printf("\t%s\n", commandtable[command][house][x]);
	    
	    /* pre-set dims need %-expandos */
	    if(command==PREDIM1)
	      {
		char *dimcommand=malloc(strlen(commandtable[command][house][x])+1);
		if(dimcommand==NULL)
		  {
		    fprintf(stderr,"Couldn't allocate memory for %s command %s !\n",
			    commands[command],commandtable[command][house][x]);
		    exit(-1);
		  }

		sprintf(dimcommand,commandtable[command][house][x],dimlevel+1);

		execute (dimcommand);

		free(dimcommand);
	      }
	    else
	      execute (commandtable[command][house][x]);
	  }
      }
}

void
execute (char *command)
{
  pid_t child;
  char *argv[4];

  argv[0] = rindex (shell, '/') + 1;
  if (argv[0] == NULL);
  argv[0] = shell;
  argv[1] = "-c";
  argv[2] = command;
  argv[3] = 0;

  child = vfork ();
  if (child == -1)
    {
      printf ("Couldn't fork to exec %s\n", command);
      return;
    }

  if (child != 0)
    {
      /* I'm the parent.  Wait for the child to die. */
      waitpid (child, NULL, 0);
      return;
    }

  /* if I've lasted this long, I must be the child */

  child = vfork ();
  if (child == -1)
    {
      printf ("Couldn't fork to exec %s\n", command);
      _exit (-1);
    }

  if (child != 0)
    {
      /* I'm the second parent and I'm dying.
         Note this is a _exit() to avoid messing up the first parent's I/O */
      _exit (0);
    }

  /* now I'm the child's child, and my parent is init */

  /* Run in a brand new session... */
  setsid ();

  /* ...and go ! */
  execve (shell, argv, environ);

  /* if control gets this far, something really icky happened */

  fprintf (stderr, "Couldn't exec %s -c %s: %s\n", shell, command, strerror (errno));
  _exit (-1);
}
