#! /usr/bin/perl -w


# Ham Radio cqzone info module cqzones.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    cqzones.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    cqzones.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

#####################################################
# addcqzone($comment, $band)
# delcqzone($comment, $band)
# checkcqzone($countryindex, $band, $call)
# @count = countcqzone();
#####################################################
use Switch;

{ # start block

for ($i = 0; $i < 41; $i++) {
	$cqzones_160[$i] = 0;
	$cqzones_80[$i] = 0;
	$cqzones_40[$i] = 0;
	$cqzones_20[$i] = 0;
	$cqzones_15[$i] = 0;
	$cqzones_10[$i] = 0;
	$cqzones_all[$i] = 0;
}
#####################################################
sub addcqzone {
#####################################################

	my ($comment, $band) = @_;
	my $zone = 0;

	eval {
		if ($comment =~ /\d+/) {
			if ($comment > 0 && $comment < 41) {
				$zone = $comment;
			} else {
				$zone = 0;
			}
		}
	};
	if ($@) { $zone = 0;}
	
	switch ($band) {
		case 160 { 
			$cqzones_160[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_160[$zone];
		}
		case 80 { 
			$cqzones_80[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_80[$zone];
		}
		case 40 { 
			$cqzones_40[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_40[$zone];
		}
		case 20 { 
			$cqzones_20[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_20[$zone];
		}
		case 15 { 
			$cqzones_15[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_15[$zone];
		}
		case 10 { 
			$cqzones_10[$zone]++;
			$cqzones_all[$zone]++;
			return $cqzones_10[$zone];
		}
	}
	
}

#####################################################
sub delcqzone {
#####################################################

	my ($country, $band, $call, $comment) = @_;
	if ($comment > 0 && $comment < 41) {
		my $zone = $comment;
	} else {
		$zone = 0;
	}
	
	switch ($band) {
		case 160 { 
			$cqzones_160[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_160[$zone];
		}
		case 80 { 
			$cqzones_80[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_80[$zone];
		}
		case 40 { 
			$cqzones_40[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_40[$zone];
		}
		case 20 { 
			$cqzones_20[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_20[$zone];
		}
		case 15 { 
			$cqzones_15[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_15[$zone];
		}
		case 10 { 
			$cqzones_10[$zone]--;
			$cqzones_all[$zone]--;
			return $cqzones_10[$zone];
		}
	}
}

#####################################################
sub checkcqzone {
#####################################################
	my ($country, $band, $call) = @_;
	my @info = getinfo($call);
	my $zone = $info[1];

	switch($band) {
		case "160" { return $cqzones_160[$zone] }	
		case " 80" { return $cqzones_80[$zone] }	
		case " 40" { return $cqzones_40[$zone] }	
		case " 20" { return $cqzones_20[$zone] }	
		case " 15" { return $cqzones_15[$zone] }	
		case " 10" { return $cqzones_10[$zone] }	
		case " 99" { return $cqzones_all[$zone] }
		else { return 0 }
	}
}
#####################################################
sub viewcqzone {
#####################################################
	my ($zone, $band) = @_;
	
	switch($band) {
		case "160" { return $cqzones_160[$zone] }	
		case " 80" { return $cqzones_80[$zone] }	
		case " 40" { return $cqzones_40[$zone] }	
		case " 20" { return $cqzones_20[$zone] }	
		case " 15" { return $cqzones_15[$zone] }	
		case " 10" { return $cqzones_10[$zone] }	
		case " 99" { return $cqzones_all[$zone] }
		else { return 0 }
	}
}

#####################################################
sub count_cqzone {
#####################################################
my $count = 0;
my @out = ();
my $val = 0;
	foreach $val (@cqzones_160) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_80) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_40) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_20) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_15) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_10) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@cqzones_all) {
		if ($val) {$count++; }
	}
	push @out, $count;
	
	return @out;

}
####################################
sub init_cqzones {
	for ($i = 0; $i < 41; $i++) {
		$cqzones_160[$i] = 0;
		$cqzones_80[$i] = 0;
		$cqzones_40[$i] = 0;
		$cqzones_20[$i] = 0;
		$cqzones_15[$i] = 0;
		$cqzones_10[$i] = 0;
		$cqzones_all[$i] = 0;
	}	
}

} # end block

1;
