
#define MAXWINDOWENTRIES 10

#define M_SAVE 0
#define M_SAVEAS 1
#define M_CLOSE 2
#define M_CUT 3
#define M_COPY 4
#define M_PASTE 5
#define M_ECHO 6
#define M_VOLUME 7
#define M_REVERSE 8
#define M_SWAP 9
#define M_PROPS 10

#define CM_PLAY 0
#define CM_STOP 1
#define CM_ZOOM 2
#define CM_CUT 3
#define CM_COPY 4
#define CM_PASTE_I 5
#define CM_PASTE_M 6
#define CM_CLOSE 7
#define CM_ALL 7

typedef void (*TopMenuCallback)();

typedef struct Right_Widgets {
	Widget			widget;
	struct Right_Widgets	*next;
} Right_Widget;

typedef	struct Top_Widgets {
	Widget			widget;
	Widget			shell;
	Right_Widget		*right;
	struct Top_Widgets	*next;
} Top_Widget;	

typedef struct Bar_Widgets {
	Widget			widget;
	Widget			button;
	Top_Widget		*tops;
	struct Bar_Widgets	*next;
} Bar_Widget;

typedef struct RightMenuItems {
	char			*name;
	bool			sensitive;
	TopMenuCallback		callback;
} RightMenuItem;
	

typedef struct TopMenuItems {
	char			*name;
	bool			sensitive;
	TopMenuCallback		callback;
	int			nitems;
	RightMenuItem		*items;
} TopMenuItem;
	

typedef struct TopMenuBars{
	char			*name;
	int			nitems;
	TopMenuItem		*items;
} TopMenuBar;


#define MI_NEW(name,sensitive,cb,nitems,items)	{name,sensitive,(TopMenuCallback)cb,nitems,items}
#define	MI_SIMPLE(name,sensitive,cb)		MI_NEW(name,sensitive,cb,0,NULL)
#define	MI_RIGHT(name,sensitive,cb,nitems,items)	MI_NEW(name,sensitive,cb,nitems,items)
#define	MI_LINE()					MI_SIMPLE("",FALSE,NULL)
#define MI_PULL(name,sensitive,cb)		{name,sensitive,(TopMenuCallback)cb}

void create_topmenu(Widget w);
void create_canvas_menu(Widget w,Main_Widget *mw);
void menu_state(bool state);
void add_menu_entry(Next_Wave *nw);
void remove_menu_entry(Next_Wave *nw);
void set_menu_state(int from, int to, bool state);
void actual_menu_wname(Main_Data *md,char *name);
void set_cmenu_state(int from, int to, bool state);

