#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "query_callbacks.h"
#include "query.h"
#include "support.h"
#include "global.h"
#include "networking.h"


gboolean
on_query_window_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

gtk_widget_destroy(query_window);
gtk_widget_set_sensitive(query,TRUE);
  return TRUE;
}


void
on_query_cancel_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
gtk_widget_destroy(query_window);
gtk_widget_set_sensitive(query,TRUE);
}


void
on_clear_query_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{

	
	GtkWidget* call = lookup_widget(GTK_WIDGET(button),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(button),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(button),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(button),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(button),"county");
	GtkWidget* lower_freq = lookup_widget(GTK_WIDGET(button),"lower_freq");
	GtkWidget* upper_freq = lookup_widget(GTK_WIDGET(button),"upper_freq");
	
	gtk_entry_set_text(GTK_ENTRY(call),"");
	gtk_entry_set_text(GTK_ENTRY(country),"");
	gtk_entry_set_text(GTK_ENTRY(state),"");
	gtk_entry_set_text(GTK_ENTRY(grid),"");
	gtk_entry_set_text(GTK_ENTRY(county),"");
	gtk_entry_set_text(GTK_ENTRY(lower_freq),"");
	gtk_entry_set_text(GTK_ENTRY(upper_freq),"");
	
}


void
on_send_query_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
gchar *call_,*country_,*state_,*grid_,*county_,*lower_freq_,*upper_freq_;
	gchar string_to_send[1000];

	
	// Sono connesso ?
	if(connection_status != 1 ) {
		write_query_statusbar("Cannot send query. You are not connected.");
	return;
	}
	GtkWidget* call = lookup_widget(GTK_WIDGET(button),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(button),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(button),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(button),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(button),"county");
	GtkWidget* lower_freq = lookup_widget(GTK_WIDGET(button),"lower_freq");
	GtkWidget* upper_freq = lookup_widget(GTK_WIDGET(button),"upper_freq");
	
	
	call_ = gtk_entry_get_text(GTK_ENTRY(call));
	country_ = gtk_entry_get_text(GTK_ENTRY(country));
	state_ = gtk_entry_get_text(GTK_ENTRY(state));
	grid_ = gtk_entry_get_text(GTK_ENTRY(grid));
	county_ = gtk_entry_get_text(GTK_ENTRY(county));
	lower_freq_ = gtk_entry_get_text(GTK_ENTRY(lower_freq));
	upper_freq_ = gtk_entry_get_text(GTK_ENTRY(upper_freq));

	if((strcmp(call_,"") == 0) && (strcmp(country_,"") == 0) && (strcmp(state_,"") == 0) && (strcmp(grid_,"") == 0) && (strcmp(lower_freq_,"") == 0) && (strcmp(upper_freq_,"") == 0) && (strcmp(county_,"") == 0) ) {
		write_query_statusbar("Cannot send query. Please fill at least one field.");
	return;
	}
		
		sprintf(string_to_send,":Q%s|%s|%s|%s|%s|%s|%s|<EOR>",call_,lower_freq_,upper_freq_,country_,state_,county_,grid_);
//printf("%s\n",string_to_send);
		tx(readchan,string_to_send);
	
	
}
