

/*

TODO:

x- if iLast==NULL, don't add texts
x- set iLast to NULL in DeleteAll
x- set iLast to NULL after a Notepad command
x- remove all code relating to the old history list.
x- remove and rethink the dirty scheme (don't respond to dirty right now)
- if there is a selection,show the input line above the output, and as
  soon as the input line is modified, don't show the output. only show
  the output again when enter is pressed, or escape, etc.
x- no resetting the cursor back to 0 when staying on the same line?
- MakeSure.... should adjust to the top, not the bottom!


  Worksheet:

  
- multi-line output items that pixel-wrap.
- scrolling the input line.
  - also scrolling arrows on the input line, and handling left, right arrows to
- caching of hints: remember the previously found hint, and
  try to figure out if a new search is warranted.
- hints in the text editor.

- merge the different tabs.cpp files, and parametrize them?
 - word wrapping based on text size in pixels also.
 - when working on the command line, only redraw the command line!
 - bug where you cannot jump to the "startup code" manual section?
 - a few more problems with html help: the examples don't go to
   the next line.
 - quick function reference and, find help on, and clickable examples
   in the help browser.
 - pass user interactions to the console out objects. These objects
   can then be anything.
 - make a helpdialog console out object.
 - menu, with settings etc.
 - mouse selections
 - have restart, ? and ?? etc

 */

#include <stdio.h>
#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Tabs.H>
#include "yacasprivate.h"
#include "FltkConsole.h"
#include "FltkHintWindow.h"
#include "HelpView.h"
#include "yacas.h"


#define SUPPORT_NOTEPAD


const char* inPrompt =  "In>  ";
const char* outPrompt = "Out> ";
const char* printPrompt =  "  ";
const char* errorPrompt = "Error> ";
const char* linkPrompt = "Link: ";
#define BufSz 512

#define SetInputFont() fl_font(FL_HELVETICA,iDefaultFontSize)
#define INPUT_PROMPT "$ "


int LoadHints(char* file);
void DisposeHints();


FltkConsole::~FltkConsole()
{
    DeleteHints();

    // Remove ALL the loaded hints from memory
    DisposeHints();
}

FltkConsole::FltkConsole(int x, int y, int w, int h, int aDefaultFontSize)
: Fl_Widget(x,y,w,h,NULL), iLast(NULL),iDefaultFontSize(aDefaultFontSize),
hints(NULL),
iOutputOffsetX(0), iOutputOffsetY(0),
iMouseDownX(0),iMouseDownY(0),iMovingOutput(0),
iOutputHeight(0),iCurrentHighlighted(-1),
iInputDirty(1),iOutputDirty(1),iShowInput(1),iEnableInput(1)
{
    {
        extern char defdir[128];
        char buf[128];
        sprintf(buf,"%shints",defdir);
        LoadHints(buf);
    }
    CommandLineStartNew();
}

void FltkConsole::DeleteAll()
{
    int nr = iConsoleOut.NrItems();
    while (nr--)
    {
        delete iConsoleOut[0];
        iConsoleOut.Delete(0);
    }
    iOutputHeight = 0;
    iLast = NULL;
    iCurrentHighlighted = -1;
}


void FltkConsole::LoadNotePad(LispCharPtr aFile)
{
    int prevshow = iShowInput;
    int prevenable = iEnableInput;


    FILE*f=fopen(aFile,"r");
    if(f)
    {
        DeleteAll();
        char buff[BufSz];
        while(fgets(buff,BufSz-2,f))
        {
            char* start;
            int i;
            for(i=0;buff[i] && buff[i] != '\n';++i)
                ;
            buff[i++] = '\0';

            int showinput = iShowInput;
            int enableinput = iEnableInput;
            int holdoutput = 0;
            int internal = 0;
            int link = 0;
            extern LispString the_out;

            start = &buff[0];
            if (start[0] == ':')
            {
                start++;
                while (*start != ':')
                {
                    switch(*start)
                    {
                    case 'n':  internal         = 1; break;
                    case 'i':  showinput        = 0; break;
                    case 'e':  enableinput      = 0; break;
                    case 'h':  holdoutput       = 1; break;
                    case 'l':  link             = 1; break;
                    }
                    start++;
                }
                start++;
            }
            

            if (!internal)
            {
                AddGroup(showinput, enableinput);
                AddText(start, FL_BLACK,inPrompt,FL_HELVETICA,iDefaultFontSize);
            }
            if (link)
            {
            NEXTLINE:
                fgets(buff,BufSz-2,f);
                if (enableinput)
                {
                    AddText(buff, FL_BLUE,linkPrompt,FL_HELVETICA_BOLD,iDefaultFontSize);
                }
                else
                {
                    if (buff[0] != ':')
                    {
                        AddText(buff, FL_BLACK,"",FL_HELVETICA_BOLD,iDefaultFontSize);
                        goto NEXTLINE;
                    }
                }
            }
            else if (!holdoutput)
            {
                extern CYacas* yacas;
                yacas->Evaluate(start);

                if (!internal)
                {
                    if (the_out[0])
                    {
                        AddText(the_out.String(), FL_RED,printPrompt,FL_COURIER,iDefaultFontSize);
                    }

                    if (yacas->Error()[0] != '\0')
                    {
                        AddText(yacas->Error(), FL_RED,errorPrompt,FL_HELVETICA,iDefaultFontSize);
                    }
                    else
                    {
                        AddText(yacas->Result(), FL_BLUE,outPrompt,FL_HELVETICA,iDefaultFontSize);
                    }
                }
            }
            the_out.SetNrItems(0);
            the_out.Append('\0');
        }
        fclose(f);
        SetInputDirty();
        SetOutputDirty();
        iCurrentHighlighted = 0;
        iOutputOffsetY = 0;
        MakeSureHighlightedVisible();
        redraw();
    }
    iShowInput = prevshow;
    iEnableInput = prevenable;
    iLast = NULL;
}


void FltkConsole::CommandLineStartNew()
{
    DeleteHints();
    /*TODO remove?
     history=iHistory.NrItems();
     iHistoryUnchanged = 0;
*/
    cursor=0;
}

void FltkConsole::SaveHistory()
{
    /*TODO remove?
     char fname[256];
    sprintf(fname,"%s/.yacas_history",getenv("HOME"));
    
    FILE*f=fopen(fname,"w");
    if (f)
    {
        int i;
        int from=0;
        if (iMaxLines>=0)
        {
            if (iHistory.NrItems()>iMaxLines)
            {
                from = iHistory.NrItems()-iMaxLines;
            }
        }
        for (i=from;i<iHistory.NrItems();i++)
        {
            fprintf(f,"%s\n",iHistory[i]->String());
        }
        fclose(f);
        }
        */
}

void FltkConsole::AddGroup()
{
    AddGroup(iShowInput, iEnableInput);
}
void FltkConsole::AddGroup(int aShowInput, int aEnableInput)
{
    iLast = new ConsoleGrouped(aShowInput, aEnableInput);
    AddOutput(iLast);
}

void FltkConsole::AddText(LispCharPtr aText,int color, const char* aPrompt,
                          int aFont, int aFontSize)
{
    if (iLast == NULL)
        return;
    ConsoleOutBase* toadd;

    char buffer[BufSz+1];
    while (aText[0] != '\0')
    {
        int len=0;

        while (aText[0] == '\n' || aText[0] == '\r') aText++;
        if (aText[0] != '\0')
        {
            while (len < BufSz && aText[len] != '\n' && aText[len] != '\r' && aText[len] != '\0')
            {
                len++;
            }
        }
        if (aText[len] == '\0')
        {
            toadd = new ConsoleFlatText(aText, color,aPrompt,aFont,aFontSize);
            iLast->Add(toadd);
            iOutputHeight+=toadd->height();
            aText+=len;
        }
        else
        {
            memcpy(buffer,aText,len);
            buffer[len] = '\0';
            toadd = new ConsoleFlatText(buffer, color,aPrompt,aFont,aFontSize);
            iLast->Add(toadd);
            iOutputHeight+=toadd->height();
            if (aText[len] == '\n') aText++;
            aText+=len;
        }
    }
    iOutputDirty = 1;
}


void FltkConsole::CommandLineEnd()
{
    DoLine(&iSubLine[0]);
}
void FltkConsole::DoLine(char* inpline)
{
    if(*inpline)
    {
        extern Fl_Tabs* mainTabs;
        extern Fl_Group* helptab;
        if (inpline[0] == '?')
        {
            if (inpline[1] == '?')
            {
                mainTabs->value(helptab);
                goto END;
            }
            else
            {
                if (strlen(&inpline[1]) < 100)
                {
                    char buf[120];
                    extern char defdir[128];

                    sprintf(buf,"%s/documentation/ref.html#%s",defdir,&inpline[1]);
                    extern void HelpGo(char*);
                    HelpGo(buf);
                }
                mainTabs->value(helptab);
                goto END;
            }
        }
        else
        {
            if (!strncmp(inpline,"restart",7))
            {
                DeleteAll();
                {
                    extern LispPtr graph;
                    graph.Set(NULL);
                }

                extern void RestartYacas();
                RestartYacas();
                goto END;
            }
            else if (!strncmp(inpline,"quit",4))
            {
                exit(0);
            }
        }
    }

#ifdef SUPPORT_NOTEPAD
    if (iCurrentHighlighted >= 0)
    {
        if (iConsoleOut[iCurrentHighlighted]->IsEditable())
        {
            iLast = (ConsoleGrouped*)iConsoleOut[iCurrentHighlighted];
            iOutputHeight -= iLast->height();
            iLast->DeleteAll();
        }
        else
            AddGroup();
    }
    else
        AddGroup();
#else
    AddGroup();
#endif
    AddText(inpline, FL_BLACK,inPrompt,FL_HELVETICA,iDefaultFontSize);
    //SetInputDirty();
    SetOutputDirty();
    redraw(); //output changed
    Fl::flush();
    {
        extern CYacas* yacas;
        yacas->Evaluate(inpline);

        extern LispString the_out;
        if (the_out[0])
        {
            AddText(the_out.String(), FL_RED,printPrompt,FL_COURIER,iDefaultFontSize);
            the_out.SetNrItems(0);
            the_out.Append('\0');
            the_out.SetNrItems(0);
            the_out.Append('\0');
        }

        if (yacas->Error()[0] != '\0')
        {
            AddText(yacas->Error(), FL_RED,errorPrompt,FL_HELVETICA,iDefaultFontSize);
        }
        else
        {
            AddText(yacas->Result(), FL_BLUE,outPrompt,FL_HELVETICA,iDefaultFontSize);
        }
    }

END:
    LispCharPtr text = "";
    if (iCurrentHighlighted >= 0)
    {
        text = iConsoleOut[iCurrentHighlighted]->input();
    }
    SetInput(text, strlen(text)+1);
}


/*
 void FltkConsole::resize(int x,int y,int w,int h)
{
    // input AND output dirty
    SetInputDirty();
    SetOutputDirty();
    Fl_Widget::resize(x,y,w,h);
}
 */

void FltkConsole::SetInput(LispCharPtr aText, LispInt nr)
{
    iSubLine.SetNrItems(0);
    LispInt i;
    for (i=0;i<nr;i++)
    {
        iSubLine.Append(aText[i]);
    }
    if (cursor >= iSubLine.NrItems())
    	cursor = iSubLine.NrItems()-1;
}
void FltkConsole::GetHistory(LispInt aLine)
{
    /*TODO remove?
     SetInput(&(*iHistory[aLine])[0], iHistory[aLine]->NrItems());
     */
}

void FltkConsole::MakeSureHighlightedVisible()
{
#ifdef SUPPORT_NOTEPAD
    if (iCurrentHighlighted < 0)
    {
        iOutputOffsetY = 0;
    }
    else
    {
        int i,nr = iConsoleOut.NrItems();
        int iy = y(), ih = h();
        int lowy = iy+ih-fl_height();
        int thisheight;
        for (i=nr-1;i>=iCurrentHighlighted;i--)
        {
            //        if (lowy+iOutputOffsetY < iy)
            //            break;
            thisheight = iConsoleOut[i]->height();

//            printf("#%d, %d pix\n",i,thisheight);
            lowy = lowy - thisheight;
            if (iCurrentHighlighted == i)
            {
                int top = lowy+iOutputOffsetY;
                int bottom = top + thisheight;

//printf("top %d, bottom %d\n",top,bottom);
                if (top < iy)
                {
//                    printf("adjusttop : %d\n",iOutputOffsetY);
                    iOutputOffsetY = (iy-lowy);
//                    printf("to : %d\n",iOutputOffsetY);
                }
                if (bottom > iy+ih-fl_height()-1)
                {
//                    printf("adjustbottom\n");
                    iOutputOffsetY = iy+ih-fl_height()-1 - lowy - thisheight;
                }
                //lowy+iOutputOffsetY,thisheight
                //fl_rect(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw, thisheight);
                break;
            }
        }
    }
//printf("item %d, offs %d\n",iCurrentHighlighted,iOutputOffsetY);
#endif
}

void FltkConsole::handle_key(int key)
{
    switch (key)
    {
    case eDelete:
        if (cursor<iSubLine.NrItems()-1)
        {
            iSubLine.Delete(cursor);
            iFullLineDirty = 1;
//TODO remove?            iHistoryUnchanged = 0;
        }
        break;
    case eBackSpace:
        if (cursor>0)
        {
            cursor--;
            iSubLine.Delete(cursor);
            iFullLineDirty = 1;
//TODO remove?            iHistoryUnchanged = 0;
        }
        break;
    case eLeft:
        if (cursor>0)
            cursor--;
        break;
    case eRight:
        if (cursor<iSubLine.NrItems()-1)
            cursor++;
        break;
    case eUp:

#ifdef SUPPORT_NOTEPAD
        {
            DeleteHints();
            if (iCurrentHighlighted>0)
                SetCurrentHighlighted(iCurrentHighlighted-1);
            else if (iCurrentHighlighted == 0)
            {
            }
            else
                SetCurrentHighlighted(iConsoleOut.NrItems()-1);
            SetOutputDirty();
            MakeSureHighlightedVisible();
            //                iOutputOffsetY += iConsoleOut[iCurrentHighlighted]->height();
            //                iOutputOffsetY -= iConsoleOut[iCurrentHighlighted]->height();
            cursor = iSubLine.NrItems()-1;
            break;
        }
#endif
        
        /*TODO remove?
         if (history>0)
        {
            history--;
            GetHistory(history);
            cursor = iSubLine.NrItems()-1;
            iFullLineDirty = 1;
            iHistoryUnchanged = 1;
            }
            */
        break;
    case eDown:
#ifdef SUPPORT_NOTEPAD
        {
            DeleteHints();
            if (iCurrentHighlighted < 0)
            {
            }
            else if (iCurrentHighlighted < iConsoleOut.NrItems()-1)
                SetCurrentHighlighted(iCurrentHighlighted+1);
            else
                SetCurrentHighlighted(-1);
            SetOutputDirty();
            MakeSureHighlightedVisible();
            cursor = iSubLine.NrItems()-1;
            break;
        }
#endif
        /*TODO remove?
        if (history<iHistory.NrItems()-1)
        {
            history++;
            GetHistory(history);
            cursor = iSubLine.NrItems()-1;
            iFullLineDirty = 1;
            iHistoryUnchanged = 1;
        }
        else if (history == iHistory.NrItems()-1)
        {
            iSubLine.SetNrItems(1);
            iSubLine[0] = '\0';
            cursor = iSubLine.NrItems()-1;
            history++;
            iFullLineDirty = 1;
        }
        */
        break;
    case eTab:
        {
/*TODO remove?
            LispInt prevhistory=history;
            history = iHistory.NrItems()-1;
            while (history>=0)
            {
                LispInt j=0;
                while (j<iSubLine.NrItems()-1 &&
                       j<iHistory[history]->NrItems())
                {
                    if (iSubLine[j] != (*iHistory[history])[j])
                        goto CONTINUE;
                    j++;
                }

                GetHistory(history);
                cursor = iSubLine.NrItems()-1;
                iFullLineDirty = 1;
                iHistoryUnchanged = 1;
                break;
            CONTINUE:
                history--;
            }
            if (history<0)
                history = prevhistory;
                */
        }
        break;
    case eEscape:
        iSubLine.SetNrItems(1);
        iSubLine[0] = '\0';
        cursor = iSubLine.NrItems()-1;
        iFullLineDirty = 1;
//TODO remove?        iHistoryUnchanged = 0;
//TODO remove?        history=iHistory.NrItems();
        DeleteHints();
        iCurrentHighlighted = -1;
        iLast = NULL;
        SetOutputDirty();
        break;
    case eHome:
        cursor=0;
        break;
    case eEnd:
        cursor=iSubLine.NrItems()-1;
        break;
    case eEnter:
        DeleteHints();
        if (iSubLine.NrItems()>1)
        {
//TODO remove?            iHistory.Append(new LispString(iSubLine));
            CommandLineEnd();
            if (iCurrentHighlighted < 0 )
                CommandLineStartNew();
        }
        else
        {
            if (iCurrentHighlighted>=0)
                if (iConsoleOut[iCurrentHighlighted]->IsEditable())
                {
                    LispCharPtr text = strdup(iConsoleOut[iCurrentHighlighted]->input());
                    DoLine(text);
                    free(text);
                }
        }
        return;
        break;
    default:
        {
            LispChar cc=(LispChar)key;
            iSubLine.Insert(cursor,cc);
            iFullLineDirty = 1;
//TODO remove?            iHistoryUnchanged = 0;
/*
            if (hints == NULL)
            {
                int ifrom,ito;
                ifrom = cursor;
                while (ifrom>0 && IsAlpha(iSubLine[ifrom])) ifrom--;
                if (!IsAlpha(iSubLine[ifrom])) ifrom++;
                if (ifrom<=cursor)
                {
                    ito = ifrom;
                    while (ito<iSubLine.NrItems() && IsAlpha(iSubLine[ito])) ito++;
                    if (ito>ifrom)
                        TryToHint(ifrom,ito);
                }
            }
*/
        }
        cursor++;
        if (hints == NULL)
          CheckForNewHints();
        break;
    }
}

struct HintItem
{
    char* base;
    char* hint;
};

/*
 HintItem hintTexts[] =
{
    {"Integrate", "Integrate(var,from,to)expression" },
    {"Sum","Sum(var,from,to,body)"},
    {"Sum","Sum(list)"},
    {"Taylor","Taylor(var,at,order)function"},
};
 */
CArrayGrower<HintItem> hintTexts;
char* htex = NULL;
int hoffsets[256];

void DisposeHints()
{
    if (htex)
        free(htex);
    htex = NULL;
}

int LoadHints(char* file)
{
    hintTexts.SetNrItems(0);
    FILE*f = fopen(file,"r");

    if (!f)
    {
        printf("File \"hints\" not found: please type make install -f makefile.linux first\n");
        exit(0);
    }

    {
        fseek(f,0,SEEK_END);
        int n = ftell(f);
        fseek(f,0,SEEK_SET);
        htex = (char*)malloc(n);
        if(htex != NULL)
        {
            fread(htex,1,n,f);
            int i=0;
            HintItem hi;
            for (;;)
            {
                while(htex[i] != ':') i++;
                if (!strncmp(&htex[i],"::",2))
                    break;

                i++;
                hi.base = &htex[i];
                while(htex[i] != ':') i++;
                htex[i] = '\0';
                i++;
                hi.hint = &htex[i];
                while(htex[i] != ':') i++;
                htex[i] = '\0';
                hintTexts.Append(hi);
            }
        }
        fclose(f);
    }
    {
        int i;
        for (i=0;i<256;i++) hoffsets[i] = -1;
        int nr = hintTexts.NrItems();
        if (nr > 0)
        {
            hoffsets[(unsigned char)hintTexts[0].base[0]] = 0;
            for (i=1;i<nr;i++)
            {
                if (hintTexts[i].base[0] != hintTexts[i-1].base[0])
                {
                    hoffsets[(unsigned char)hintTexts[i].base[0]] = i;
                }
            }
        }
    }
    return hintTexts.NrItems();
}



void FltkConsole::TryToHint(int ifrom,int ito)
{
    int nrhints = hintTexts.NrItems();
    int i,start;
    start = hoffsets[(unsigned char)iSubLine[ifrom]];
    if (start<0)
        return;
    for (i = start;i<nrhints;i++)
    {
        if ((unsigned char)iSubLine[ifrom] < (unsigned char)hintTexts[i].base[0])
            break;
        if (!strncmp(&iSubLine[ifrom],hintTexts[i].base,strlen(hintTexts[i].base)))
        {
            if (hints == NULL)
                CreateHints();
            AddHintLine(hintTexts[i].hint);
        }
    }
}

void FltkConsole::CheckForNewHints()
{
	int braces = 1;

	int ifrom,ito;
	ito = cursor;

	while (ito > 0 && braces > 0)
	{
	  ito --;
	  if (iSubLine[ito] == '(')
		braces--;
	  if (iSubLine[ito] == ')')
		braces++;
	}
	if (braces == 0 && ito>0)
	{
	  ifrom = ito-1;
	  while (ifrom>0 && IsAlpha(iSubLine[ifrom])) ifrom--;
	  if (ifrom >= 0)
		if (!IsAlpha(iSubLine[ifrom])) ifrom++;
	  if (ito>ifrom)
		TryToHint(ifrom,ito);
	}
}

void FltkConsole::SetCurrentHighlighted(int i)
{

    if (iCurrentHighlighted != i)
    {
        DeleteHints();

        iCurrentHighlighted = i;

        if (iCurrentHighlighted >= 0 && iConsoleOut[i]->InputIsVisible())
        {
            LispCharPtr text = iConsoleOut[iCurrentHighlighted]->input();
            SetInput(text, strlen(text)+1);
        }
        else
        {
            SetInput("", 1);
        }
    }
}

int FltkConsole::handle(int event)
{
    //printf("event %d\n",event);
    switch (event)
    {
        /*
         case FL_SHOW:
        SetInputDirty();
        SetOutputDirty();
        redraw(); //input and output changed
        break;
        */
    case FL_PUSH: //mouse down
    case FL_DRAG:
        {
            SetInputFont();
            int yy = Fl::event_y();
            if (yy > y() + h()-(int)fl_height())
            {
                int xx = Fl::event_x();
                int i = 0;
                int width = x() + (int)fl_width(INPUT_PROMPT);

                for (i=0;i<iSubLine.NrItems()-1;i++)
                {
                    int added = (int)fl_width(iSubLine[i]);
                    if (width + added > xx)
                        break;
                    width += added;
                }
                cursor = i;
                SetInputDirty();
                //SetOutputDirty();
                redraw(); //input changed
            }
            else
            {
                if (event == FL_PUSH)
                {
                    iMovingOutput = 1;
                    iMoveBaseX = iOutputOffsetX;
                    iMoveBaseY = iOutputOffsetY;
                    iMouseDownX = Fl::event_x();
                    iMouseDownY = Fl::event_y();

#ifdef SUPPORT_NOTEPAD
                    {
                        int prevHighlight = iCurrentHighlighted;
                        iCurrentHighlighted = -1;
                        fl_font(FL_HELVETICA,iDefaultFontSize);
                        int iy = y(), ih = h();
                        int lowy = iy+ih-fl_height();
                        int i,nr = iConsoleOut.NrItems();
                        for (i=nr-1;i>=0;i--)
                        {
                            if (lowy+iOutputOffsetY < iy)
                                break;
                            if (lowy+iOutputOffsetY>iMouseDownY && lowy+iOutputOffsetY - iConsoleOut[i]->height()<iMouseDownY)
                            {
                                if (prevHighlight == i)
                                {
                                    iCurrentHighlighted = i;
                                    //TODO maybe?  handle_key(eEnter);
                                }
                                else
                                {
                                    SetCurrentHighlighted(i);
                                    SetInputDirty();
                                    SetOutputDirty();
                                    redraw();//input and output changed
                                }
                                break;
                            }
                            lowy = lowy - iConsoleOut[i]->height();
                        }
                    }
#endif
                }
                else
                {
                    iOutputOffsetX = iMoveBaseX + Fl::event_x() - iMouseDownX;
                    iOutputOffsetY = iMoveBaseY + Fl::event_y()  - iMouseDownY;

                    if (iOutputOffsetX > 0) iOutputOffsetX = 0;
                    if (iOutputOffsetX < -600) iOutputOffsetX = -600;
                    
                    if (iOutputOffsetY < 0) iOutputOffsetY = 0;
                    if (iOutputOffsetY > iOutputHeight) iOutputOffsetY = iOutputHeight;
                    //SetInputDirty();
                    SetOutputDirty();
                    redraw(); //output changed
                }
            }
        }
        break;
    case FL_RELEASE: //mouse up
        iMovingOutput = 0;
        break;
    case FL_KEYBOARD:
        {
            int c = Fl::event_key();
            switch (c)
            {
            case FL_BackSpace    : handle_key(eBackSpace); break;
            case FL_Tab          : handle_key(eTab); break;
            case FL_Enter        : handle_key(eEnter); break;
            case FL_Escape       : handle_key(eEscape); break;
            case FL_Home         : handle_key(eHome); break;
            case FL_Left         : handle_key(eLeft); break;
            case FL_Up           : handle_key(eUp); break;
            case FL_Right        : handle_key(eRight); break;
            case FL_Down         : handle_key(eDown); break;
            case FL_End          : handle_key(eEnd); break;
            case FL_Delete       : handle_key(eDelete); break;
            case FL_Page_Up      :
                {
                    int delta = h()/4;
                    if (Fl::event_shift())
                    {
                         if (iOutputOffsetY+delta < iOutputHeight)
                            iOutputOffsetY += delta;
                        else
                            iOutputOffsetY = iOutputHeight;
                    }
                    else
                    {
                        handle_key(eUp);
                    }
                }
                break;
            case FL_Page_Down    :
                {
                    int delta = h()/4;
                    if (Fl::event_shift())
                    {
                        if (iOutputOffsetY-delta > 0)
                            iOutputOffsetY -= delta;
                        else
                            iOutputOffsetY = 0;
                    }
                    else
                    {
                        handle_key(eDown);
                    }
                }
                break;
            default              :
                c =Fl::event_text()[0];
                if (c>=32 && c<127)
                    handle_key(c);
                break;
            }
            SetInputDirty();
            redraw(); //input changed
        }
        break;
    }
    return 1;
}

void FltkConsole::InsertText(const LispCharPtr aText)
{
   while(*aText) 
   {
    LispChar c = *aText++; 
    iSubLine.Insert(cursor++,c);
   }
   if (hints == NULL)
     CheckForNewHints();
}

//iCurrentHighlighted
void FltkConsole::draw()
{
    fl_font(FL_HELVETICA,iDefaultFontSize);
    fl_clip(x(),y(),w(),h());
    fl_color(FL_WHITE);
    fl_rectf(x(),y(),w(),h());
    if (iCurrentHighlighted >= 0)
        if (iConsoleOut[iCurrentHighlighted]->IsEditable() &&
            iConsoleOut[iCurrentHighlighted]->InputIsVisible())
        {
            DrawInterEdit();
            fl_pop_clip();
            return;
        }
    DrawUnderEdit();
    fl_pop_clip();
    return;
}
void FltkConsole::DrawInterEdit()
{
    fl_clip(x(),y(),w(),h());

    int i,nr = iConsoleOut.NrItems();
    int ix = x(),iy = y(), iw = w(), ih = h();
    int lowy = iy+ih-fl_height();
    int inputlowy = y()+h()-fl_height()-fl_descent();
    for (i=nr-1;i>=0;i--)
    {
        if (lowy+iOutputOffsetY < iy)
            break;
        int selected = (iCurrentHighlighted == i);
        int thisheight = iConsoleOut[i]->height(!selected);

        lowy = lowy - thisheight;
        iConsoleOut[i]->draw(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw,!selected);
#ifdef SUPPORT_NOTEPAD
        if (iCurrentHighlighted == i)
        {
            SetInputFont();
            lowy -= fl_height();
            inputlowy = lowy+iOutputOffsetY;
            DrawInputLine(lowy+iOutputOffsetY);

            fl_color(FL_BLACK);
            fl_rect(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw, thisheight+fl_height());
        }
#endif
    }

    if (hints)
    {
        fl_font(FL_HELVETICA,iDefaultFontSize);
        hints->draw(x(),inputlowy-3);
    }

    
    fl_pop_clip();
    iOutputDirty = 0;
    return;
}
void FltkConsole::DrawInputLine(int lowy)
{
    const char* text = &iSubLine[0];
    int iix =  x() + (int)fl_width(INPUT_PROMPT);
    int cur = iix+(int)fl_width(text, cursor);

    int limit = x()+w()-8;
    if (cur > limit)
    {
        iix += (limit - cur);
        cur = limit;
    }

    SetInputFont();
    fl_color(FL_RED);
    fl_draw(INPUT_PROMPT,x(),lowy+fl_height()-fl_descent());

    fl_clip(x() + (int)fl_width(INPUT_PROMPT),lowy,w()-(int)fl_width(INPUT_PROMPT),fl_height());

    fl_draw(text,iix,lowy+fl_height()-fl_descent());

    fl_color(FL_BLACK);
    fl_begin_line();
    fl_vertex(cur,lowy);
    fl_vertex(cur,lowy+fl_height());
    fl_end_line();

    fl_pop_clip();
    iInputDirty = 0;
}

void FltkConsole::DrawUnderEdit()
{
    int i,nr;
    nr = iConsoleOut.NrItems();
    int ix = x(),iy = y(), iw = w(), ih = h();
    int lowy = iy+ih-fl_height();

    DrawInputLine(lowy);


//    if (iOutputDirty)
    {
        fl_clip(x(),y(),w(),h()-fl_height());
        for (i=nr-1;i>=0;i--)
        {
            if (lowy+iOutputOffsetY < iy)
                break;
            int thisheight = iConsoleOut[i]->height();
            lowy = lowy - thisheight;
            iConsoleOut[i]->draw(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw);
#ifdef SUPPORT_NOTEPAD
            if (iCurrentHighlighted == i)
            {
                fl_color(FL_BLACK);
                fl_rect(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw, thisheight);
            }
#endif
        }
        fl_pop_clip();

        if (hints)
        {
            fl_font(FL_HELVETICA,iDefaultFontSize);
            hints->draw(x(),y()+h()-fl_height()-fl_descent()-3);
        }
    }
    iOutputDirty = 0;
    return;
/*TODO remove?
    fl_font(FL_HELVETICA,iDefaultFontSize);
    fl_clip(x(),y(),w(),h());
    fl_color(FL_WHITE);


    int i,nr;
    nr = iConsoleOut.NrItems();
    int ix = x(),iy = y(), iw = w(), ih = h();
    int lowy = iy+ih-fl_height();

//    if (iInputDirty)
    {
        fl_rectf(x(),lowy,w(),fl_height());
    }
//    if (iOutputDirty)
    {
        fl_rectf(x(),y(),w(),ih-fl_height());
    }

    
//    if (iInputDirty)
    {
        const char* text = &iSubLine[0];
        int iix =  ix + (int)fl_width(INPUT_PROMPT);
        int cur = iix+(int)fl_width(text, cursor);

        int limit = x()+w()-8;
        if (cur > limit)
        {
            iix += (limit - cur);
            cur = limit;
        }
        
        SetInputFont();
        fl_color(FL_RED);
        fl_draw(INPUT_PROMPT,ix,lowy+fl_height()-fl_descent());


        fl_clip(ix + (int)fl_width(INPUT_PROMPT),lowy,w()-(int)fl_width(INPUT_PROMPT),fl_height());

        fl_draw(text,iix,lowy+fl_height()-fl_descent());

        fl_color(FL_BLACK);
        fl_begin_line();
        fl_vertex(cur,lowy);
        fl_vertex(cur,lowy+fl_height());
        fl_end_line();

        fl_pop_clip();
    }
    iInputDirty = 0;
    fl_pop_clip();


//    if (iOutputDirty)
    {
        fl_clip(x(),y(),w(),h()-fl_height());
        for (i=nr-1;i>=0;i--)
        {
            if (lowy+iOutputOffsetY < iy)
                break;
            int thisheight = iConsoleOut[i]->height();
            lowy = lowy - thisheight;
            iConsoleOut[i]->draw(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw);
#ifdef SUPPORT_NOTEPAD
            if (iCurrentHighlighted == i)
            {
                fl_color(FL_BLACK);
                fl_rect(ix+iOutputOffsetX, lowy+iOutputOffsetY, iw, thisheight);
            }
#endif
        }
        fl_pop_clip();

        if (hints)
        {
            fl_font(FL_HELVETICA,iDefaultFontSize);
            hints->draw(x(),y()+h()-fl_height()-fl_descent()-3);
        }
    }
    iOutputDirty = 0;
    return;
*/
}

void FltkConsole::AddOutput(ConsoleOutBase* aOutput)
{
    iConsoleOut.Append(aOutput);
    iOutputHeight+=aOutput->height();
}

void FltkConsole::DeleteHints()
{
    if (hints != NULL)
    {
        delete hints;
        hints = NULL;
        iOutputDirty=1;
    }
}

void FltkConsole::CreateHints()
{
    DeleteHints();
    hints = new FltkHintWindow(iDefaultFontSize);
    iOutputDirty=1;
}
void FltkConsole::AddHintLine(LispCharPtr aText)
{
    hints->AddLine(aText);
}

ConsoleOutBase::~ConsoleOutBase()
{
}

ConsoleFlatText::ConsoleFlatText(LispCharPtr aText, int aColor, const char* aPrompt,
                                 int aFont,int aFontSize)
{
    iText = aText;
    iColor = aColor;
    iPrompt = aPrompt;
    iFont = aFont;
    iFontSize = aFontSize;
}
void ConsoleFlatText::draw(int x, int y, int width,int draw_input)
{
    fl_font(iFont,iFontSize);

    y += fl_height()-fl_descent();
    int promptWidth = (int)fl_width(iPrompt);
    fl_color(FL_GREEN);
    fl_draw(iPrompt,x,y);

    //    fl_clip(x,y,width,height());
    fl_color(iColor);
    const char* text = &iText[0];
    fl_draw(text,x+promptWidth,y);
}
int ConsoleFlatText::height(int draw_input)
{
    fl_font(iFont,iFontSize);
    return fl_height();
}
LispCharPtr ConsoleFlatText::input()
{
    return &iText[0];
}
LispCharPtr ConsoleGrouped::input()
{
    if (!iEnableInput)
        return "";
    if (iConsoleOut.NrItems()>0)
        return iConsoleOut[0]->input();
    return "";
}

void ConsoleGrouped::Add(ConsoleOutBase* aLine)
{
    iConsoleOut.Append(aLine);
}
void ConsoleGrouped::draw(int x, int y, int width,int draw_input)
{
    int i, nr,from;

    if (iShowInput && draw_input)
        from = 0;
    else
        from = 1;
    nr = iConsoleOut.NrItems();
    for (i=from;i<nr;i++)
    {
        iConsoleOut[i]->draw(x, y, width);
        y+=iConsoleOut[i]->height();
    }
}
int ConsoleGrouped::height(int draw_input)
{
    int i, nr,h,from;
    if (iShowInput && draw_input)
        from = 0;
    else
        from = 1;
        
    nr = iConsoleOut.NrItems();
    h=0;
    for (i=from;i<nr;i++)
    {
        h+=iConsoleOut[i]->height();
    }
    return h;
}
void ConsoleGrouped::DeleteAll()
{
    int i,nr;
    nr = iConsoleOut.NrItems();
    for (i=0;i<nr;i++)
    {
        delete iConsoleOut[0];
        iConsoleOut.Delete(0);
    }
}
int ConsoleGrouped::IsEditable()
{
    return iEnableInput;
}
int ConsoleGrouped::InputIsVisible()
{
    return iShowInput;
}

LispCharPtr ConsoleOutBase::input()
{
    return "";
}

int ConsoleOutBase::IsEditable()
{
    return 0;
}
int ConsoleOutBase::InputIsVisible()
{
    return 0;
}
