/*
 * gdd_notes.h
 */
/*
 * yank  -  yet another NoteKeeper
 * Copyright (C) 1999, 2000, 2001 Michael Humann <m.hussmann@home.ins.de>
 *
 * This program is free software; you  can redistribute it and/or modify it
 * under the terms of  the GNU General  Public License as published  by the
 * Free Software Foundation;  either version 2 of  the License, or (at your
 * option) any later version.
 *
 * This program  is  distributed in the  hope  that it will  be useful, but
 * WITHOUT  ANY   WARRANTY;  without   even   the  implied    warranty   of
 * MERCHANTABILITY or    FITNESS FOR A PARTICULAR   PURPOSE.   See  the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write to the  Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef YANK_GDD_NOTES_H
#define YANK_GDD_NOTES_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif   /* HAVE_CONFIG_H */

#include <gnome.h>
#include "notedefs.h"
#include "gdd.h"

typedef struct _gdd_note gdd_note;
struct _gdd_note
{

    Gdd       *gdd;             
    GtkWidget *widget;          /* ptr to the widget */
    gchar     *menuname;        /* name in menu (bad for translation) */
    gchar     *gladepath;       /* rel. or abs. path to the glade file */
    gchar     *iconpath;        /* rel. or abs. path to icon if found */
    GtkWidget *iconwidget;
};

#define GDD_NOTES_ROOT_WIDGET "vbox"

gint       gdd_notes_build_list(void);
gint       gdd_notes_build_menu(const gchar *mpath);

/* FIXME: remove these ... */

void       gdd_notes_fill_note_data_from_page(note_data *note);
void       gdd_notes_fill_page_from_note_data(note_data *note);
GtkWidget* gdd_notes_choose_icon(note_data *note);
void       gdd_notes_clear_gui(GtkWidget *widget);
void       gdd_notes_fill_widget(note_data *note);

#endif /* YANK_GDD_NOTES_H */

