/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_GUILE_SCRIPT_H)
#define __INC_GUILE_SCRIPT_H

#include <glib.h>

#include <string>

extern "C" {
#include <libguile.h>
}

#include <sigc++/slot.h>
#include <sigc++/object_slot.h>

#include <sigcx/thread_tunnel.h>
#include <sigcx/thread.h>

#include "yehia/script.h"

namespace Yehia
{

namespace Script
{

class guileObject;

class guileObjectFactory : public ObjectFactory
{
  public:
    guileObjectFactory();
    virtual ~guileObjectFactory();
    
    // We define this, since we allow 'null' intances in Guile
    Object& wrap_instance(const Object& klass, SigC::Object *obj);

    void yehia_init_fixup();
    
    virtual Object& create_value(const Any& v);    
    virtual Object& create_genfunc();
    virtual Object& create_class(const Signature& supers);
    virtual Object& wrap_instance(const Object& klass, SigC::Object& obj) {
      return wrap_instance(klass, &obj);
    }
    virtual Object& create_namespace();

    virtual Object& null_object();
    
    guileObject& create_object(SCM sobj);
    Any scm_to_any(SCM sobj);
    
    union SmallInfo
    {
        SCM sval;
        unsigned char slotmem[sizeof(Slot)];
    };
    
    static void *smallinfo_new();
    static size_t smallinfo_free(void *);
    
    SCM to_scmobj(const Any& v);
  private:
    virtual void destroy(Object& obj);
    
    GMemChunk *memchunk_;
    guileObject *null_obj_;
    guileObject *sigc_obj_class_;  
    
    static GMemChunk *smallinfo_memchunk_;
    static int refcnt_;
};

class guileObject : public Object,
		    protected Instance, protected Namespace,
                    protected GenFunc, protected Class
{
  public:
    guileObject(guileObjectFactory& factory, SCM sobj = SCM_UNSPECIFIED);
    virtual ~guileObject();
    
    guileObjectFactory& factory() const {
      return dynamic_cast<guileObjectFactory&>(Script::Object::factory());
    }
    
    virtual Namespace *namespace_interface();
    virtual Instance *instance_interface();
    virtual Function *function_interface();
    virtual GenFunc *genfunc_interface();
    virtual Class *class_interface();
    
    // Value
    virtual Any value() const;

    // Instance interface
    virtual SigC::Object& object();
    Script::Object& class_object();

    // Namespace interface
    virtual Script::Object *member(const std::string& name);
    virtual void insert(const std::string& name, Script::Object& object);
    
    // GenericFunction interface
    virtual void add_method(const Slot& slot, const Signature& sig);
    virtual Script::Object *call(const ParamList& args);
    
    // Class interface
    virtual void set_constructor(Object& genfunc);
    virtual void add_genfunc(const std::string& name, Object& genfunc);
    virtual void add_class_genfunc(const std::string& name, Object& genfunc);
    virtual void add_setter(const std::string& name, Object& genfunc);
    virtual void add_getter(const std::string& name, Object& genfunc);
    
    // Utilities
    void ensure(bool cond);
    bool is_null();
    guileObject& operator=(SCM sobj);
    SCM sobj() const;
  private:
    SCM sobj_;
    SCM module_;
};

}

}

#endif
