/* This is for emacs: -*-Mode: C++;-*- */
#if !defined(_INC_YEHIA_NET_SERVER_H)
#define _INC_YEHIA_NET_SERVER_H

#include <sigcx/dispatch.h>
#include <yehia/error-handler.h>
#include <yehia/net/socket.h>

namespace Yehia
{

namespace Net
{

class Server : public ErrorHandler
{
  public:
    Server();
    Server(ErrorHandler& parent);
    virtual ~Server();

    /** Add a socket to listen to. */
    void add_socket(Socket sock);
    
    /** Remove a socket to listen to. */
    void remove_socket(Socket sock);

    /** Run the event loop. */
    bool run(bool forever = true) { return disp_.run(forever); }

    const SigCX::Dispatcher& dispatcher() const { return disp_; }
    SigCX::Dispatcher& dispatcher() { return disp_; }
  protected:
    virtual void handle_new_connection(Socket newsock) = 0;
    virtual bool do_accept_on(Socket sock) = 0;
  private:
    typedef SigCX::Dispatcher::HandlerID HandlerID;
    typedef std::map<Socket, HandlerID> SockMap;
    
    SockMap sockets_;
    SigCX::StandardDispatcher disp_;

    void handle_connect(Socket sock);
};

}

}

#endif
