/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include "types.h"
#include "console.h"
#include "globals.h"
#include "movecheck.h"
#include "style.h"
#include "vars.h"
#include "util.h"

Style styles[] = {
	{12,	style12},
	{0,	NULL},
};

static const char values[] = {0, 1, 3, 3, 5, 9, 0};

StyleHandler getstyle(int style) {
	Style *srch = styles;

	while (srch->handler != NULL) {
		if (srch->style == style)
			return srch->handler;
		srch++;
	}

	return NULL;
}

void style12(Table *t) {
	int x, y, p, wv = 0, bv = 0;
	static char s12[256], tmp[256];
	Game *s = t->game;
	char relation = 0;
	char *wh, *bh;
	const int ms = variables[VAR_MS].number;

	printf("\n<12> ");

	wh = s12;
	for (y = 7; y >= 0; y--) {
		for (x = 0; x < 8; x++) {
			p = s->board[x][y];
			if (p == EMPTY) {
				*(wh++) = '-';
			} else {
				if (iswhite(p)) {
					*(wh++) = *wpstring[p];
					wv += values[p];
				} else {
					*(wh++) = *bpstring[piecetype(p)];
					bv += values[piecetype(p)];
				}
			}
		}
		*(wh++) = ' ';
	}
	*wh = '\0';

	snprintf(tmp, sizeof(tmp), "%c %d %d %d %d %d %d ",
		(s->turn == WHITE) ? 'W' : 'B',
		s->dpush,
		s->castlewa, s->castlewh,
		s->castleba, s->castlebh,
		s->lastirrev);
	mstrncat(s12, tmp, sizeof(s12));

	if (t->players[0] == NULL) {
		relation = -3;
		wh = "_EMPTY_";
	} else {
		wh = t->players[0]->handle;
	}

	if (t->players[1] == NULL) {
		relation = -3;
		bh = "_EMPTY_";
	} else {
		bh = t->players[1]->handle;
	}

	if (t->players[0] == pme) {		/* I'm playing white */
		relation = (char)((s->turn == WHITE) ? 1 : -1);
	} else if (t->players[1] == pme) {	/* I'm playing black */
		relation = (char)((s->turn == BLACK) ? 1 : -1);
	}

	x = (s->halfmoves + 2) / 2;

	/* XXX: See comment in platform.h regarding i64fmt. */
	snprintf(tmp, sizeof(tmp),
		"%d %s %s %d %d %d %d %d %.0f %.0f %d %s (%s) %s %d %d\n",
		t->number,
		wh, bh,
		relation,
		(int)tabletime(t), (int)tableinc(t),
		wv, bv,
		(float)(ms ? timeleft(t, 0) : timeleft(t, 0) / 1000),
		(float)(ms ? timeleft(t, 1) : timeleft(t, 1) / 1000),
		x,
		(s->move != NULL) ? s->move->desc : "none",
		fmttime_ms((s->move != NULL) ? s->move->timeTaken : 0),
		(s->move != NULL) ? s->move->alg : "none",
		0, /* we never invert the board */
		(tabletime(t) != 0) ? 1 : 0 /* clock only ticking when untimed */);

	mstrncat(s12, tmp, sizeof(s12));
	printf("%s", s12);
	prompt();
}
