/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "version.h"
#include "vars.h"

char VERSION[] = "0.1.2";

String *getIdent(String *str) {
	String *iface = variables[VAR_INTERFACE].string;

	StringSet(str, "Using YICS ", -1);
	StringCat(str, VERSION, -1);

#if (defined (linux) || defined (__linux) || defined (__linux__))
# define VERSION_OSNAME "Linux"
#elif (defined (unix) || defined (__unix) || defined (__unix__))
# define VERSION_OSNAME "Unix"
#elif (defined (WINNT) || defined (__WINNT) || defined (__WINNT__) || defined (_WIN32) || defined (_WINDOWS))
# define VERSION_OSNAME "Windows"
#else
# define VERSION_OSNAME ""
#endif

#ifdef VERSION_OSNAME
	StringCat(str, " on " VERSION_OSNAME, -1);
# undef VERSION_OSNAME
#endif

	if ((iface != NULL) && (iface->length > 0)) {
		StringCat(str, " (with ", -1);
		StringCat(str, iface->string, iface->length);
		StringCat(str, ")", -1);
	}

	StringCat(str, ".  http://www.yics.org", -1);

	return str;
}
