#ifndef CONFIG_H
#define CONFIG_H

/*
 *	Default YIFF Sound Server configuration file location:
 *
 *	Full path to the YIFF Sound Server configuration file, it
 *	can also be specified from the command line at run time.
 */
#define DEF_RCFILE_NAME         "/usr/etc/yiffrc"
/* Alternate name */
/*
#define DEF_RCFILE_NAME		"/usr/etc/YIFFConfig"
*/

/*
 *	Default Y mixer device channel settings file:
 *
 *	This file is stored in the user's home directory.
 */
#define DEF_RCMIXERFILE_NAME         ".YMixerSettings"


/*
 *	Default port:
 *
 *	This is the default port number client programs connect to
 *	this program on.
 */
#define DEF_PORT	9433


/*
 *	Default sound device:
 */
#define DEF_DEVICE	"/dev/dsp"

/*
 *      Default mixer device:
 */
#define DEF_MIXER	"/dev/mixer"


/*
 *	Default midi player program command:
 *
 *	Requires full path to program and %f is replaced with the
 *	full path of the file being played.
 */
#if defined(ALSA_RUN_CONFORM) && !defined(DEF_MIDI_CMD)
# define DEF_MIDI_CMD	"/usr/bin/pmidi -p 65:0 %f"
#endif

#if defined(OSS) && !defined(DEF_MIDI_CMD)
# define DEF_MIDI_CMD	"/usr/bin/drvmidi --interface=d %f"
#endif

#if !defined(DEF_MIDI_CMD)
# define DEF_MIDI_CMD	"/usr/bin/playmidi %f"
#endif


/*
 *	Default sample size (8 or 16 bits):
 */
#define DEF_SAMPLE_SIZE		8

/*
 *	Default number of channels (1 or 2):
 */
#define DEF_CHANNELS		1

/*
 *	Default sample rate (in Hz):
 */
#define DEF_SAMPLE_RATE		11025


/*
 *	Minimum sample rate (in Hz):
 */
#define MIN_SAMPLE_RATE		5000


#endif	/* CONFIG_H */
