#ifndef MIDI_H
#define MIDI_H

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>


/*
 *	Midi return error codes:
 */
#define MidiSuccess		0
#define MidiBadValue		1
#define MidiNoBuffers		2
#define MidiNoAccess		3
#define MidiErrorNotMidi	4


/*
 *	Chunk type names:
 */
#define MidiChunkTypeNameHeader	"MThd"
#define MidiChunkTypeNameTrack	"MTrk"


/*
 *	Chunk type length in bytes:
 *
 *	Not counting NULL terminating byte.
 */
#define MidiChunkTypeNameLen	4

/*
 *	Chunk types:
 */
#define	MidiChunkTypeUnknown	0
#define MidiChunkTypeHeader	1
#define MidiChunkTypeTrack	2


/*
 *	Midi track event structure.
 */
typedef struct {

        int type;       /* One of MidiEventType*. */
	int dtime;	/* Delta time. */

} MidiEventStruct;

/*
 *	Midi chunk structure:
 */
typedef struct {

	int type;		/* One of MidiChunkType*. */
	u_int32_t len;


	/* Raw data contained in this chunk (except chunk type
	 * and length information.
	 */
	u_int8_t *buf;
	int buf_len;	/* len - 8. */


	/* Events if type is MidiChunkTypeTrack. */
	MidiEventStruct	**event;
	int		total_events;

} MidiChunkStruct;

/*
 *	Midi data structure:
 */
typedef struct {

	char *filename;

	/* Header. */
	int format;
	int tracks;	/* Number of tracks. */
	int divisions;

	/* Chunks. */
	MidiChunkStruct **chunk;
	int total_chunks;

} MidiDataStruct;


extern int MidiIsFileMidi(const char *filename);
extern int MidiRead(const char *filename, FILE *fp, MidiDataStruct *md);
extern void MidiDestroy(MidiDataStruct *md);



#endif	/* MIDI_H */
