/*
	Audio preset modes.

	Used in simple mode changing by referancing a mode preset by
	an identifier name.
 */

#ifndef YMODES_H
#define YMODES_H

#include "ytiming.h"
#include "ytypes.h"


typedef struct {

	/*   Identifier name (alias) to refferance this mode
	 *   by.
	 */
	char *name;

	/* Audio parameters, see structure Audio in ysound.h. */
        YDeltaTime      cycle;
        YDeltaTime      write_ahead;
        int sample_size;
        int channels;
        int sample_rate;
        YDataLength bytes_per_second;	/* (not used). */
#ifdef OSS_BUFFRAG
        Boolean allow_fragments;
        u_int8_t num_fragments;
        u_int8_t fragment_size;	/* In shifts, not bytes! */
#endif	/* OSS_BUFFRAG */
        Boolean flip_stereo;
        int direction;

} YMode;

extern YMode **ymode;
extern int total_ymodes;


/*
 *	Functions:
 */
extern int YModeIsAllocated(int n);
extern YMode *YModeGetPtr(int n);
extern int YModeMatch(const char *name);

extern int YModeAllocate(const char *name);
extern void YModeReset(int n);
extern void YModeDelete(int n);
extern void YModeDeleteAll(void);
extern void YModeReclaim(void);


#endif	/* YMODES_H */
