/*
    BINIT.C

    Initialization routines for stand alone binary file package.

    $Id: binit.c,v 1.1 1993/08/27 18:32:09 munro Exp $
 */
/*    Copyright (c) 1994.  The Regents of the University of California.
                    All rights reserved.  */

#define NOT_YORICK

#include "binio.h"
#include "defmem.h"

/* Include file automatically generated by the FMCALC program.  */
#include "prmtyp.h"

/* ------------------------------------------------------------------------ */

extern void InitStructDefs(void);   /* defined below */

Operations charOps, shortOps, intOps, longOps, floatOps, doubleOps,
  complexOps, stringOps, pointerOps, structOps, structDefOps, streamOps;

Operations *yOpsStruct= &structOps;
Operations *yOpsStream= &streamOps;
Operations *yOpsStructDef= &structDefOps;

Operations charOps= { &FreeArray };
Operations shortOps= { &FreeArray };
Operations intOps= { &FreeArray };
Operations longOps= { &FreeArray };
Operations floatOps= { &FreeArray };
Operations doubleOps= { &FreeArray };
Operations complexOps= { &FreeArray };
Operations stringOps= { &FreeArray };
Operations pointerOps= { &FreeArray };
Operations structOps= { &FreeArray };
Operations structDefOps= { &FreeStructDef };
Operations streamOps= { &FreeIOStream };

/* ------------------------------------------------------------------------ */

/* Floating point layouts for floats and doubles on this machine */
static FPLayout fltSLayout= FLOAT_LAYOUT;
static FPLayout dblSLayout= DOUBLE_LAYOUT;
FPLayout *fltLayout= &fltSLayout;
FPLayout *dblLayout= &dblSLayout;

StructDef charStruct = {
  0, &structDefOps, &charOps, sizeof(char),
  CHAR_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 0, 0, 0, 0, 0, 0 };

StructDef shortStruct = {
  0, &structDefOps, &shortOps, sizeof(short),
  SHORT_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 1, 0, 0, 0, SHORT_ORDER, 0 };

StructDef intStruct = {
  0, &structDefOps, &intOps, sizeof(int),
  INT_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 2, 0, 0, 0, INT_ORDER, 0 };

StructDef longStruct = {
  0, &structDefOps, &longOps, sizeof(long),
  LONG_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 3, 0, 0, 0, LONG_ORDER, 0 };

StructDef floatStruct = {
  0, &structDefOps, &floatOps, sizeof(float),
  FLOAT_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 4, 0, 0, 0, FLOAT_ORDER, &fltSLayout };

StructDef doubleStruct = {
  0, &structDefOps, &doubleOps, sizeof(double),
  DOUBLE_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 5, 0, 0, 0, DOUBLE_ORDER, &dblSLayout };

StructDef stringStruct = {
  0, &structDefOps, &stringOps, sizeof(char *),
  POINTER_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyQ, 0, 6, 0, 0, 0, 0, 0 };

StructDef pointerStruct = {
  0, &structDefOps, &pointerOps, sizeof(void *),
  POINTER_ALIGN, {0, 0, 0, 0, 0}, 0, 0,
  &CopyP, 0, 7, 0, 0, 0, 0, 0 };

StructDef complexStruct = {
  0, &structDefOps, 0 /* &complexOps */, 0 /* 2*sizeof(double) */,
  0 /* DOUBLE_ALIGN */, {0, 0, 0, 0, 0}, 0, 0,
  &CopyX, 0, 8, 0, 0, 0, 0, 0 };

int yStructAlign= STRUCT_ALIGN;

HashTable yStructTable;
StructDef **yStructList= 0;

static void PrimInstall(char *name, StructDef *base);

void (*DefInstallHook)(const char *name, StructDef *base)= 0;

static void PrimInstall(char *name, StructDef *base)
{
  HashAdd(&yStructTable, name, 0L);
  HASH_MANAGE(yStructTable, StructDef *, yStructList);
  yStructList[hashIndex]= base;
  if (DefInstallHook) DefInstallHook(name, base);
}

void InitStructDefs(void)
{
  /* install the basic StructDefs into the global symbol table --
     this order is critical */
  PrimInstall("char", &charStruct);
  PrimInstall("short", &shortStruct);
  PrimInstall("int", &intStruct);
  PrimInstall("long", &longStruct);
  PrimInstall("float", &floatStruct);
  PrimInstall("double", &doubleStruct);
  PrimInstall("string", &stringStruct);
  PrimInstall("pointer", &pointerStruct);

  /* define the re and im parts of complex */
  HashAdd(&yStructTable, "complex", 0L);
  HASH_MANAGE(yStructTable, StructDef *, yStructList);
  yStructList[hashIndex]= &complexStruct;
  AddMember(&complexStruct, -1L, "re", &doubleStruct, (Dimension *)0);
  AddMember(&complexStruct, -1L, "im", &doubleStruct, (Dimension *)0);
  InstallStruct(&complexStruct, (StructDef *)0);
  complexStruct.dataOps= &complexOps;
}

/* ------------------------------------------------------------------------ */
